/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import java.util.Collection;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CGMaintenanceDocumentRuleBaseTest
extends MaintenanceRuleTestBase {
    private CGMaintenanceDocumentRuleBase rule;
    private Agency agency;
    private long agencyNumber;
    private BusinessObjectService boService;
    private Award award;
    private Long proposalNumber;

    public void setUp() throws Exception {
        this.rule = new CGMaintenanceDocumentRuleBase();
        this.agencyNumber = new Long(55076L);
        this.proposalNumber = new Long(39603L);
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.award = (Award)this.boService.findBySinglePrimaryKey(Award.class, (Object)this.proposalNumber);
        this.agency = (Agency)this.boService.findBySinglePrimaryKey(Agency.class, (Object)this.agencyNumber);
    }

    public void testCheckEndAfterBegin() {
        Date begin = new Date(11111L);
        Date end = new Date(11115L);
        CGMaintenanceDocumentRuleBaseTest.assertFalse((boolean)this.rule.checkEndAfterBegin(begin, begin, ""));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkEndAfterBegin(begin, end, ""));
    }

    public void testAll() {
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkPrimary((Collection)this.agency.getAgencyAddresses(), AgencyAddress.class, "agencyAddresses", Agency.class));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkProjectDirectorsExist(this.award.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkFundManagersExist(this.award.getAwardFundManagers(), "awardFundManagers"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkProjectDirectorsExist(this.award.getAwardAccounts(), AwardAccount.class, "awardAccounts"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkProjectDirectorsStatuses(this.award.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkFederalPassThrough(this.award.getFederalPassThroughIndicator(), this.award.getAgency(), this.award.getFederalPassThroughAgencyNumber(), Award.class, "federalPassThroughIndicator"));
        CGMaintenanceDocumentRuleBaseTest.assertTrue((boolean)this.rule.checkAgencyNotEqualToFederalPassThroughAgency(this.award.getAgency(), this.award.getFederalPassThroughAgency(), "agencyNumber", "federalPassThroughAgencyNumber"));
    }
}

