/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject.inquiry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableMilestoneSchedule;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.AccountsReceivablePredeterminedBillingSchedule;
import org.kuali.kfs.kns.datadictionary.InquirySectionDefinition;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.inquiry.InquiryRestrictions;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.kns.web.ui.SectionBridge;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.service.ContractsAndGrantsBillingService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;

public class AwardInquirableImpl
extends KualiInquirableImpl {
    private static final Logger LOG = Logger.getLogger(AwardInquirableImpl.class);

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if (StringUtils.equals((String)"milestoneSchedule.milestoneScheduleInquiryTitle", (String)attributeName)) {
            return this.buildInquiryUrl(businessObject, AccountsReceivableMilestoneSchedule.class);
        }
        if (StringUtils.equals((String)"predeterminedBillingSchedule.predeterminedBillingScheduleInquiryTitle", (String)attributeName)) {
            return this.buildInquiryUrl(businessObject, AccountsReceivablePredeterminedBillingSchedule.class);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

    protected HtmlData.AnchorHtmlData buildInquiryUrl(BusinessObject businessObject, Class businessObjectClass) {
        HtmlData.AnchorHtmlData inquiryHref = new HtmlData.AnchorHtmlData("", "");
        String baseUrl = "inquiry.do";
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("businessObjectClassName", businessObjectClass.getName());
        parameters.put("proposalNumber", ObjectUtils.getPropertyValue((Object)businessObject, (String)"proposalNumber").toString());
        inquiryHref.setHref(UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters));
        return inquiryHref;
    }

    public List<Section> getSections(BusinessObject businessObject) {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (this.getBusinessObjectClass() == null) {
            LOG.error((Object)"Business object class not set in inquirable.");
            throw new RuntimeException("Business object class not set in inquirable.");
        }
        Award award = (Award)businessObject;
        InquiryRestrictions inquiryRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getInquiryRestrictions(businessObject, GlobalVariables.getUserSession().getPerson());
        List inquirySections = this.getBusinessObjectDictionaryService().getInquirySections(this.getBusinessObjectClass());
        Collection<?> sectionIdsToIgnore = this.getSectionIdsToIgnore();
        for (InquirySectionDefinition inquirySection : inquirySections) {
            Section section;
            String sectionId = inquirySection.getId();
            if (inquiryRestrictions.isHiddenSectionId(sectionId) || sectionIdsToIgnore.contains(sectionId)) continue;
            if (StringUtils.equals((String)sectionId, (String)"predeterminedBillingScheduleSection")) {
                if (!StringUtils.equals((String)award.getBillingFrequencyCode(), (String)"PDBS") || !((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).hasPredeterminedBillingSchedule(award.getProposalNumber())) continue;
                section = SectionBridge.toSection((Inquirable)this, (InquirySectionDefinition)inquirySection, (BusinessObject)businessObject, (InquiryRestrictions)inquiryRestrictions);
                sections.add(section);
                continue;
            }
            if (StringUtils.equals((String)sectionId, (String)"milestoneScheduleSection")) {
                if (!StringUtils.equals((String)award.getBillingFrequencyCode(), (String)"MILE") || !((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).hasMilestoneSchedule(award.getProposalNumber())) continue;
                section = SectionBridge.toSection((Inquirable)this, (InquirySectionDefinition)inquirySection, (BusinessObject)businessObject, (InquiryRestrictions)inquiryRestrictions);
                sections.add(section);
                continue;
            }
            section = SectionBridge.toSection((Inquirable)this, (InquirySectionDefinition)inquirySection, (BusinessObject)businessObject, (InquiryRestrictions)inquiryRestrictions);
            sections.add(section);
        }
        return sections;
    }

    protected Collection<?> getSectionIdsToIgnore() {
        if (!((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).isContractsGrantsBillingEnhancementActive()) {
            return ((ContractsAndGrantsBillingService)SpringContext.getBean(ContractsAndGrantsBillingService.class)).getAwardContractsGrantsBillingSectionIds();
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }
}

