/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.service.AwardService;

public class ContractsAndGrantsModuleBillingServiceImpl
implements ContractsAndGrantsModuleBillingService {
    protected AwardService awardService;
    protected BusinessObjectService businessObjectService;
    protected LookupService LookupService;

    public List<? extends ContractsAndGrantsAward> lookupAwards(Map<String, String> fieldValues, boolean unbounded) {
        String date;
        String value = fieldValues.remove("accountNumber");
        if (StringUtils.isNotBlank((String)value)) {
            fieldValues.put("awardAccounts.account.accountNumber", value);
        }
        if (StringUtils.isNotBlank((String)(value = fieldValues.remove("awardBillingFrequency")))) {
            fieldValues.put("billingFrequencyCode", value);
        }
        if (StringUtils.isNotBlank((String)(value = fieldValues.remove("awardTotal")))) {
            fieldValues.put("awardTotalAmount", value);
        }
        if (StringUtils.isNotEmpty((String)fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate")) && StringUtils.isNotEmpty((String)fieldValues.get("awardBeginningDate"))) {
            date = fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate") + ".." + fieldValues.remove("awardBeginningDate");
            fieldValues.put("awardBeginningDate", date);
        } else if (StringUtils.isEmpty((String)fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate")) && StringUtils.isNotEmpty((String)fieldValues.get("awardBeginningDate"))) {
            date = "<=" + fieldValues.remove("awardBeginningDate");
            fieldValues.put("awardBeginningDate", date);
        } else if (StringUtils.isEmpty((String)fieldValues.get("awardBeginningDate")) && StringUtils.isNotEmpty((String)fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate"))) {
            date = ">=" + fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
            fieldValues.put("awardBeginningDate", date);
        }
        if (StringUtils.isNotEmpty((String)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate")) && StringUtils.isNotEmpty((String)fieldValues.get("awardEndingDate"))) {
            date = fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate") + ".." + fieldValues.remove("awardEndingDate");
            fieldValues.put("awardEndingDate", date);
        } else if (StringUtils.isEmpty((String)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate")) && StringUtils.isNotEmpty((String)fieldValues.get("awardEndingDate"))) {
            date = "<=" + fieldValues.remove("awardEndingDate");
            fieldValues.put("awardEndingDate", date);
        } else if (StringUtils.isEmpty((String)fieldValues.get("awardEndingDate")) && StringUtils.isNotEmpty((String)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate"))) {
            date = ">=" + fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate");
            fieldValues.put("awardEndingDate", date);
        }
        return (List)this.LookupService.findCollectionBySearchHelper(Award.class, fieldValues, unbounded);
    }

    public ContractsAndGrantsBillingAward updateAwardIfNecessary(Long proposalNumber, ContractsAndGrantsBillingAward currentAward) {
        ContractsAndGrantsBillingAward award = currentAward;
        if (ObjectUtils.isNull((Object)proposalNumber)) {
            award = null;
        } else if (ObjectUtils.isNull((Object)currentAward) || !currentAward.getProposalNumber().equals(proposalNumber)) {
            award = this.awardService.getByPrimaryId(proposalNumber);
        }
        return award;
    }

    public void setLastBilledDateToAwardAccount(Map<String, Object> criteria, boolean invoiceReversal, Date lastBilledDate) {
        AwardAccount awardAccount = (AwardAccount)this.getBusinessObjectService().findByPrimaryKey(AwardAccount.class, criteria);
        if (invoiceReversal) {
            awardAccount.setCurrentLastBilledDate(awardAccount.getPreviousLastBilledDate());
            awardAccount.setPreviousLastBilledDate(null);
        } else {
            awardAccount.setPreviousLastBilledDate(awardAccount.getCurrentLastBilledDate());
            awardAccount.setCurrentLastBilledDate(lastBilledDate);
        }
        this.getBusinessObjectService().save((PersistableBusinessObject)awardAccount);
    }

    public void setLastBilledDateToAward(Long proposalNumber, Date lastBilledDate) {
    }

    public void setFinalBilledToAwardAccount(Map<String, Object> criteria, boolean finalBilled) {
        AwardAccount awardAccount = (AwardAccount)this.getBusinessObjectService().findByPrimaryKey(AwardAccount.class, criteria);
        awardAccount.setFinalBilledIndicator(finalBilled);
        this.getBusinessObjectService().save((PersistableBusinessObject)awardAccount);
    }

    public void setFinalBilledAndLastBilledDateToAwardAccount(Map<String, Object> criteria, boolean finalBilled, boolean invoiceReversal, Date lastBilledDate) {
        AwardAccount awardAccount = (AwardAccount)this.getBusinessObjectService().findByPrimaryKey(AwardAccount.class, criteria);
        if (invoiceReversal) {
            awardAccount.setCurrentLastBilledDate(awardAccount.getPreviousLastBilledDate());
            awardAccount.setPreviousLastBilledDate(null);
        } else {
            awardAccount.setPreviousLastBilledDate(awardAccount.getCurrentLastBilledDate());
            awardAccount.setCurrentLastBilledDate(lastBilledDate);
        }
        awardAccount.setFinalBilledIndicator(finalBilled);
        this.getBusinessObjectService().save((PersistableBusinessObject)awardAccount);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public LookupService getLookupService() {
        return this.LookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.LookupService = lookupService;
    }
}

