/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.batch;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.cg.businessobject.CfdaUpdateResults;
import org.kuali.kfs.module.cg.service.CfdaService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.kfs.sys.mail.BodyMailMessage;
import org.kuali.kfs.sys.mail.MailMessage;
import org.kuali.kfs.sys.service.EmailService;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class CfdaBatchStep
extends AbstractStep {
    private static final Logger LOG = Logger.getLogger(CfdaBatchStep.class);
    protected CfdaService cfdaService;
    protected EmailService emailService;
    protected ParameterService parameterService;
    protected ConfigurationService configurationService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        LOG.debug((Object)"execute() started");
        BodyMailMessage message = new BodyMailMessage();
        try {
            CfdaUpdateResults results = this.cfdaService.update();
            StringBuilder builder = new StringBuilder();
            builder.append("The CFDA batch script is complete.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite());
            builder.append(" records were deactivated because they are no longer on the web site.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecordsInKfsDatabase());
            builder.append(" records were in the KFS database.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecordsNewlyAddedFromWebSite());
            builder.append(" records were newly added from the web site.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecordsNotUpdatedBecauseManual());
            builder.append(" records were not updated because they are manual.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecordsReActivated());
            builder.append(" records were re-activated.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecordsRetrievedFromWebSite());
            builder.append(" records were retrieved from the web site.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecordsUpdatedBecauseAutomatic());
            builder.append(" records were updated because they are automatic.\n");
            builder.append(" - ");
            builder.append(results.getNumberOfRecrodsNotUpdatedForHistoricalPurposes());
            builder.append(" records were not updated for historical reasons.\n");
            builder.append(" - Message\n");
            builder.append(null != results.getMessage() ? results.getMessage() : "");
            LOG.info((Object)message.toString());
            Collection listservAddresses = this.parameterService.getParameterValuesAsString(CfdaBatchStep.class, "RESULT_SUMMARY_TO_EMAIL_ADDRESSES");
            if (listservAddresses.isEmpty()) {
                LOG.fatal((Object)"execute() No addresses for notification to in RESULT_SUMMARY_TO_EMAIL_ADDRESSES parameter.  Aborting Email.");
                return true;
            }
            for (String listserv : listservAddresses) {
                LOG.info((Object)("execute() Mailing to: " + listserv));
                message.addToAddress(listserv);
            }
            message.setFromAddress((String)listservAddresses.iterator().next());
            message.setSubject(this.configurationService.getPropertyValueAsString("cfda.updateEmail.subject"));
            message.setMessage(builder.toString());
            this.emailService.sendMessage((MailMessage)message, false);
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Exception while updating CFDA codes.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    public void setCfdaService(CfdaService cfdaService) {
        this.cfdaService = cfdaService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

