/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject.lookup;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.ContractsGrantsAwardBalancesReport;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsAwardBalancesReportLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static Logger LOG = Logger.getLogger(ContractsGrantsAwardBalancesReportLookupableHelperServiceImpl.class);
    protected AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;
    protected DateTimeService dateTimeService;

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        String awardBeginningDateFrom = fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
        this.validateDateField(awardBeginningDateFrom, "rangeLowerBoundKeyPrefix_awardBeginningDate");
        String awardBeginningDateTo = fieldValues.get("awardBeginningDate");
        this.validateDateField(awardBeginningDateTo, "awardBeginningDate");
        String awardEndingDateFrom = fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
        this.validateDateField(awardEndingDateFrom, "rangeLowerBoundKeyPrefix_awardBeginningDate");
        String awardEndingDateTo = fieldValues.get("awardEndingDate");
        this.validateDateField(awardEndingDateTo, "awardEndingDate");
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean unbounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        Map<String, String> lookupCriteria = this.buildCriteriaForLookup(lookupFormFields);
        ArrayList<ContractsGrantsAwardBalancesReport> displayList = new ArrayList<ContractsGrantsAwardBalancesReport>();
        Collection awards = this.getLookupService().findCollectionBySearchHelper(Award.class, lookupCriteria, true);
        for (Award award : awards) {
            ContractsGrantsAwardBalancesReport awardBalancesReportEntry = new ContractsGrantsAwardBalancesReport();
            awardBalancesReportEntry.setProposalNumber(award.getProposalNumber());
            awardBalancesReportEntry.setAgencyNumber(award.getAgencyNumber());
            awardBalancesReportEntry.setAgency(award.getAgency());
            awardBalancesReportEntry.setAwardProjectTitle(award.getAwardProjectTitle());
            awardBalancesReportEntry.setAwardStatusCode(award.getAwardStatusCode());
            awardBalancesReportEntry.setAwardBeginningDate(award.getAwardBeginningDate());
            awardBalancesReportEntry.setAwardEndingDate(award.getAwardEndingDate());
            String primaryProjectDirectorName = ObjectUtils.isNull((Object)award.getAwardPrimaryProjectDirector()) || ObjectUtils.isNull((Object)award.getAwardPrimaryProjectDirector().getProjectDirector()) ? "" : award.getAwardPrimaryProjectDirector().getProjectDirector().getName();
            awardBalancesReportEntry.setAwardPrimaryProjectDirectorName(primaryProjectDirectorName);
            String primaryFundManagerName = ObjectUtils.isNull((Object)award.getAwardPrimaryFundManager()) || ObjectUtils.isNull((Object)award.getAwardPrimaryFundManager().getFundManager()) ? "" : award.getAwardPrimaryFundManager().getFundManager().getName();
            awardBalancesReportEntry.setAwardPrimaryFundManagerName(primaryFundManagerName);
            awardBalancesReportEntry.setAwardTotalAmountForReport(award.getAwardTotalAmount());
            KualiDecimal awardBilledToDateAmount = this.getAccountsReceivableModuleBillingService().getAwardBilledToDateAmount((ContractsAndGrantsBillingAward)award);
            awardBalancesReportEntry.setTotalBilledToDate(awardBilledToDateAmount);
            KualiDecimal totalPayments = this.getAccountsReceivableModuleBillingService().calculateTotalPaymentsToDateByAward(award.getProposalNumber());
            awardBalancesReportEntry.setTotalPaymentsToDate(totalPayments);
            awardBalancesReportEntry.setAmountCurrentlyDue((KualiDecimal)awardBilledToDateAmount.subtract((AbstractKualiDecimal)totalPayments));
            displayList.add(awardBalancesReportEntry);
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    protected Map<String, String> buildCriteriaForLookup(Map lookupFormFields) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        String proposalNumber = (String)lookupFormFields.get("proposalNumber");
        criteria.put("proposalNumber", proposalNumber);
        String agencyNumber = (String)lookupFormFields.get("agencyNumber");
        criteria.put("agencyNumber", agencyNumber);
        String awardProjectTitle = (String)lookupFormFields.get("awardProjectTitle");
        criteria.put("awardProjectTitle", awardProjectTitle);
        String awardBeginningDateFrom = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
        String awardBeginningDateTo = (String)lookupFormFields.get("awardBeginningDate");
        String awardBeginningDate = this.fixDateCriteria(awardBeginningDateFrom, awardBeginningDateTo);
        criteria.put("awardBeginningDate", awardBeginningDate);
        String awardEndingDateFrom = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
        String awardEndingDateTo = (String)lookupFormFields.get("awardEndingDate");
        String awardEndingDate = this.fixDateCriteria(awardEndingDateFrom, awardEndingDateTo);
        criteria.put("awardEndingDate", awardEndingDate);
        String awardStatusCode = (String)lookupFormFields.get("awardStatusCode");
        criteria.put("awardStatusCode", awardStatusCode);
        return criteria;
    }

    protected void buildResultTable(LookupForm lookupForm, Collection displayList, Collection resultTable) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasReturnableRow = false;
        for (BusinessObject element : displayList) {
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            List columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                String propValueBeforePotientalMasking = propValue;
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
            }
            ResultRow row = new ResultRow(columns, "", "&nbsp;");
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            boolean rowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(rowReturnable);
            if (rowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
    }

    protected String createTitleText(Class<? extends BusinessObject> boClass) {
        String objectLabel;
        String titleText = "";
        String titlePrefixProp = this.getKualiConfigurationService().getPropertyValueAsString("title.inquiry.url.value.prependtext");
        if (StringUtils.isNotBlank((CharSequence)titlePrefixProp)) {
            titleText = titleText + titlePrefixProp + " ";
        }
        if (StringUtils.isNotBlank((CharSequence)(objectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(boClass.getName()).getObjectLabel()))) {
            titleText = titleText + objectLabel + " ";
        }
        return titleText;
    }

    protected String fixDateCriteria(String dateLowerBound, String dateUpperBound) {
        if (!StringUtils.isBlank((CharSequence)dateLowerBound)) {
            if (!StringUtils.isBlank((CharSequence)dateUpperBound)) {
                return dateLowerBound + ".." + dateUpperBound;
            }
            return ">=" + dateLowerBound;
        }
        if (!StringUtils.isBlank((CharSequence)dateUpperBound)) {
            return "<=" + dateUpperBound;
        }
        return null;
    }

    protected void validateDateField(String dateFieldValue, String dateFieldPropertyName) {
        if (!StringUtils.isBlank((CharSequence)dateFieldValue)) {
            try {
                this.getDateTimeService().convertToDate(dateFieldValue);
            }
            catch (ParseException pe) {
                this.addDateTimeError(dateFieldPropertyName);
            }
        }
    }

    protected void addDateTimeError(String dateFieldPropertyName) {
        String attributeProperty = dateFieldPropertyName.startsWith("rangeLowerBoundKeyPrefix_") ? dateFieldPropertyName.substring("rangeLowerBoundKeyPrefix_".length()) : dateFieldPropertyName;
        String label = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), attributeProperty);
        GlobalVariables.getMessageMap().putError(dateFieldPropertyName, "error.invalidDateTime", new String[]{label});
    }

    public AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        return this.accountsReceivableModuleBillingService;
    }

    public void setAccountsReceivableModuleBillingService(AccountsReceivableModuleBillingService accountsReceivableModuleBillingService) {
        this.accountsReceivableModuleBillingService = accountsReceivableModuleBillingService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

