/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.document.validation.impl.MaintenancePreRulesBase;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardPreRules
extends MaintenancePreRulesBase {
    protected static Logger LOG = Logger.getLogger(AwardPreRules.class);
    protected ConfigurationService configService;
    protected DataDictionaryService dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
    protected Award newAward;

    public AwardPreRules() {
        this.configService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
    }

    protected boolean doCustomPreRules(MaintenanceDocument document) {
        this.setupConvenienceObjects(document);
        boolean proceed = true;
        if (proceed) {
            proceed = this.continueIfEntryDateBeforeBeginDate();
        }
        if (proceed) {
            proceed = this.continueIfSubcontractorTotalGreaterThanAwardTotal();
        }
        if (!proceed) {
            this.abortRulesCheck();
        }
        return true;
    }

    protected boolean continueIfEntryDateBeforeBeginDate() {
        boolean proceed = true;
        Date entryDate = this.newAward.getAwardEntryDate();
        Date beginDate = this.newAward.getAwardBeginningDate();
        if (ObjectUtils.isNotNull((Object)entryDate) && ObjectUtils.isNotNull((Object)beginDate) && entryDate.before(beginDate)) {
            String entryDateLabel = this.dataDictionaryService.getAttributeErrorLabel(Award.class, "awardEntryDate");
            String beginDateLabel = this.dataDictionaryService.getAttributeErrorLabel(Award.class, "awardBeginningDate");
            proceed = this.askOrAnalyzeYesNoQuestion("entryDateBeforeStartDate", this.buildConfirmationQuestion("warning.cg.award.entryDateBeforeStartDate", entryDateLabel, beginDateLabel));
        }
        return proceed;
    }

    protected boolean continueIfSubcontractorTotalGreaterThanAwardTotal() {
        boolean proceed = true;
        KualiDecimal awardTotal = this.newAward.getAwardTotalAmount();
        KualiDecimal subcontractorTotal = this.newAward.getAwardSubcontractorsTotalAmount();
        if (ObjectUtils.isNotNull((Object)awardTotal) && subcontractorTotal.isGreaterThan((AbstractKualiDecimal)awardTotal) || ObjectUtils.isNull((Object)awardTotal) && subcontractorTotal.isPositive()) {
            String subcontracorLabel = this.dataDictionaryService.getCollectionLabel(Award.class, "awardSubcontractors");
            String awardLabel = this.dataDictionaryService.getAttributeErrorLabel(Award.class, "awardTotalAmount");
            proceed = this.askOrAnalyzeYesNoQuestion("subcontractorTotalGreaterThanAwardTotal", this.buildConfirmationQuestion("warning.cg.award.subcontractorAmountGreaterThanAwardAmount", subcontracorLabel, awardLabel));
        }
        return proceed;
    }

    protected String buildConfirmationQuestion(String messageKey, String ... parameters) {
        String result = this.configService.getPropertyValueAsString(messageKey);
        if (null != parameters) {
            for (int i = 0; i < parameters.length; ++i) {
                result = StringUtils.replace((String)result, (String)("{" + i + "}"), (String)parameters[i]);
            }
        }
        return result;
    }

    protected void setupConvenienceObjects(MaintenanceDocument document) {
        this.newAward = (Award)document.getNewMaintainableObject().getBusinessObject();
    }
}

