/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.batch.CfdaBatchStep;
import org.kuali.kfs.module.cg.businessobject.CFDA;
import org.kuali.kfs.module.cg.businessobject.CfdaUpdateResults;
import org.kuali.kfs.module.cg.service.CfdaService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

public class CfdaServiceImpl
implements CfdaService {
    private static final Logger LOG = Logger.getLogger(CfdaServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected static Comparator cfdaComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String lhs = (String)o1;
            String rhs = (String)o2;
            return lhs.compareTo(rhs);
        }
    };
    private DateTimeService dateTimeService;
    protected ParameterService parameterService;

    @NonTransactional
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, CFDA> getGovCodes() throws IOException {
        Calendar calendar = this.dateTimeService.getCurrentCalendar();
        TreeMap<String, CFDA> govMap = new TreeMap<String, CFDA>();
        String govURL = this.parameterService.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL");
        String fileName = StringUtils.substringAfterLast((String)govURL, (String)"/");
        if (StringUtils.contains((CharSequence)(govURL = StringUtils.substringBeforeLast((String)govURL, (String)"/")), (CharSequence)"ftp://")) {
            govURL = StringUtils.remove((String)govURL, (String)"ftp://");
        }
        String year = "" + calendar.get(1);
        year = year.substring(2, 4);
        fileName = fileName + year;
        fileName = fileName + String.format("%03d", calendar.get(6) - 1);
        fileName = fileName + ".csv";
        LOG.info((Object)("Getting government file: " + fileName + " for update"));
        InputStream inputStream = null;
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(govURL);
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                LOG.error((Object)"FTP connection to server not established.");
                throw new IOException("FTP connection to server not established.");
            }
            boolean isLoggedIn = ftp.login("anonymous", "");
            if (!isLoggedIn) {
                LOG.error((Object)"Could not login as anonymous.");
                throw new IOException("Could not login as anonymous.");
            }
            LOG.info((Object)"Successfully connected and logged in");
            ftp.enterLocalPassiveMode();
            inputStream = ftp.retrieveFileStream(fileName);
            if (inputStream != null) {
                LOG.info((Object)"reading input stream");
                InputStreamReader screenReader = new InputStreamReader(inputStream);
                BufferedReader screen = new BufferedReader(screenReader);
                CSVReader csvReader = new CSVReader((Reader)screenReader, ',', '\"', 1);
                List lines = csvReader.readAll();
                for (String[] line : lines) {
                    String title = line[0];
                    String number = line[1];
                    CFDA cfda = new CFDA();
                    cfda.setCfdaNumber(number);
                    cfda.setCfdaProgramTitleName(title);
                    govMap.put(number, cfda);
                }
            }
            ftp.logout();
            ftp.disconnect();
        }
        finally {
            if (ftp.isConnected()) {
                ftp.disconnect();
            }
        }
        return govMap;
    }

    public SortedMap<String, CFDA> getKfsCodes() throws IOException {
        Collection allCodes = this.businessObjectService.findAll(CFDA.class);
        TreeMap<String, CFDA> kfsMapAll = new TreeMap<String, CFDA>(cfdaComparator);
        for (Object o : allCodes) {
            CFDA c = (CFDA)((Object)o);
            kfsMapAll.put(c.getCfdaNumber(), c);
        }
        return kfsMapAll;
    }

    @Override
    @Transactional
    public CfdaUpdateResults update() throws IOException {
        CfdaUpdateResults results = new CfdaUpdateResults();
        SortedMap<String, CFDA> govMap = null;
        try {
            govMap = this.getGovCodes();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error connecting to URL resource: " + ioe.getMessage()), (Throwable)ioe);
            StringBuilder builder = new StringBuilder();
            builder.append("No updates took place.\n");
            builder.append(ioe.getMessage());
            results.setMessage(builder.toString());
            return results;
        }
        SortedMap<String, CFDA> kfsMap = this.getKfsCodes();
        results.setNumberOfRecordsInKfsDatabase(kfsMap.keySet().size());
        results.setNumberOfRecordsRetrievedFromWebSite(govMap.keySet().size());
        for (Object key : kfsMap.keySet()) {
            CFDA cfdaKfs = (CFDA)((Object)kfsMap.get(key));
            CFDA cfdaGov = (CFDA)((Object)govMap.get(key));
            if (cfdaKfs.getCfdaMaintenanceTypeId().startsWith("M")) {
                results.setNumberOfRecordsNotUpdatedBecauseManual(1 + results.getNumberOfRecordsNotUpdatedBecauseManual());
            } else if (cfdaKfs.getCfdaMaintenanceTypeId().startsWith("A")) {
                if (cfdaGov == null) {
                    if (cfdaKfs.isActive()) {
                        cfdaKfs.setActive(false);
                        this.businessObjectService.save((PersistableBusinessObject)cfdaKfs);
                        results.setNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite(results.getNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite() + 1);
                    } else {
                        results.setNumberOfRecrodsNotUpdatedForHistoricalPurposes(results.getNumberOfRecrodsNotUpdatedForHistoricalPurposes() + 1);
                    }
                } else {
                    if (cfdaKfs.isActive()) {
                        results.setNumberOfRecordsUpdatedBecauseAutomatic(results.getNumberOfRecordsUpdatedBecauseAutomatic() + 1);
                    } else {
                        cfdaKfs.setActive(true);
                        results.setNumberOfRecordsReActivated(results.getNumberOfRecordsReActivated() + 1);
                    }
                    cfdaKfs.setCfdaProgramTitleName(cfdaGov.getCfdaProgramTitleName());
                    this.businessObjectService.save((PersistableBusinessObject)cfdaKfs);
                }
            }
            govMap.remove(key);
        }
        for (Object key : govMap.keySet()) {
            CFDA cfdaGov = (CFDA)((Object)govMap.get(key));
            cfdaGov.setCfdaMaintenanceTypeId("AUTOMATIC");
            cfdaGov.setActive(true);
            this.businessObjectService.save((PersistableBusinessObject)cfdaGov);
            results.setNumberOfRecordsNewlyAddedFromWebSite(results.getNumberOfRecordsNewlyAddedFromWebSite() + 1);
        }
        return results;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public CFDA getByPrimaryId(String cfdaNumber) {
        if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
            return null;
        }
        return (CFDA)this.businessObjectService.findBySinglePrimaryKey(CFDA.class, (Object)cfdaNumber.trim());
    }
}

