/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import java.sql.Date;
import java.text.MessageFormat;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.module.cg.dataaccess.CloseDao;
import org.kuali.kfs.module.cg.document.ProposalAwardCloseDocument;
import org.kuali.kfs.module.cg.service.CloseService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CloseServiceImpl
implements CloseService {
    protected CloseDao closeDao;
    protected DateTimeService dateTimeService;
    protected BusinessObjectService businessObjectService;
    protected DocumentService documentService;
    protected static Logger LOG = Logger.getLogger(CloseServiceImpl.class);
    protected ConfigurationService configService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        Date today = this.dateTimeService.getCurrentSqlDateMidnight();
        ProposalAwardCloseDocument max = this.getMaxApprovedClose(today);
        if (null == max) {
            return true;
        }
        boolean result = true;
        String noteText = null;
        if (max.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames().contains("Unprocessed")) {
            try {
                Collection<Proposal> proposals = this.closeDao.getProposalsToClose(max);
                Long proposalCloseCount = new Long(proposals.size());
                for (Proposal p : proposals) {
                    p.setProposalClosingDate(today);
                    this.businessObjectService.save((PersistableBusinessObject)p);
                }
                Collection<Award> awards = this.closeDao.getAwardsToClose(max);
                Long awardCloseCount = new Long(awards.size());
                for (Award a : awards) {
                    a.setAwardClosingDate(today);
                    this.businessObjectService.save((PersistableBusinessObject)a);
                }
                max.setAwardClosedCount(awardCloseCount);
                max.setProposalClosedCount(proposalCloseCount);
                this.businessObjectService.save((PersistableBusinessObject)max);
                noteText = this.configService.getPropertyValueAsString("message.closeJob.succeeded");
                result = this.addDocumentNoteAfterClosing(max, noteText);
            }
            catch (Exception e) {
                try {
                    String messageProperty = this.configService.getPropertyValueAsString("error.cg.closeJobFailed");
                    noteText = MessageFormat.format(messageProperty, e.getMessage(), e.getCause().getMessage());
                    result = this.addDocumentNoteAfterClosing(max, noteText);
                }
                catch (Throwable throwable) {
                    result = this.addDocumentNoteAfterClosing(max, noteText);
                    throw throwable;
                }
            }
        }
        return result;
    }

    @Override
    public ProposalAwardCloseDocument getMostRecentClose() {
        Date today = this.dateTimeService.getCurrentSqlDateMidnight();
        String documentNumber = this.closeDao.getMostRecentClose(today);
        if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
            try {
                return (ProposalAwardCloseDocument)this.documentService.getByDocumentHeaderId(documentNumber);
            }
            catch (WorkflowException we) {
                throw new RuntimeException(we);
            }
        }
        return null;
    }

    protected boolean addDocumentNoteAfterClosing(ProposalAwardCloseDocument close, String noteText) {
        try {
            this.documentService.createNoteFromDocument((Document)close, noteText);
            this.documentService.approveDocument((Document)close, noteText, null);
        }
        catch (WorkflowException we) {
            LOG.error((Object)"problem during CloseServiceImpl.addDocumentNoteAfterClosing()", (Throwable)we);
            return false;
        }
        return true;
    }

    @Override
    public ProposalAwardCloseDocument getMaxApprovedClose(Date today) {
        String documentNumber = this.closeDao.getMaxApprovedClose(today);
        if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
            try {
                return (ProposalAwardCloseDocument)this.documentService.getByDocumentHeaderId(documentNumber);
            }
            catch (WorkflowException we) {
                throw new RuntimeException(we);
            }
        }
        return null;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setCloseDao(CloseDao closeDao) {
        this.closeDao = closeDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setConfigService(ConfigurationService configService) {
        this.configService = configService;
    }
}

