/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.BusinessObject;

public class AgencyLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static Logger LOG = Logger.getLogger(AgencyLookupableHelperServiceImpl.class);
    protected AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        if (!CollectionUtils.isEmpty((Collection)htmlDataList)) {
            htmlDataList.add(this.getAgencyAwardLookupUrl(businessObject));
        }
        return htmlDataList;
    }

    private HtmlData.AnchorHtmlData getAgencyAwardLookupUrl(BusinessObject bo) {
        Agency agency = (Agency)bo;
        String baseUrl = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url") + "/" + "kr/lookup.do";
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", Award.class.getName());
        parameters.put("methodToCall", "search");
        parameters.put("agencyNumber", agency.getAgencyNumber());
        String href = UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
        return new HtmlData.AnchorHtmlData(href, "search", "Awards");
    }

    protected void setRows() {
        List lookupFieldNames = null;
        if (this.getBusinessObjectMetaDataService().isLookupable(this.getBusinessObjectClass())) {
            lookupFieldNames = this.getBusinessObjectMetaDataService().getLookupableFieldNames(this.getBusinessObjectClass());
        }
        if (lookupFieldNames == null) {
            throw new RuntimeException("Lookup not defined for business object " + this.getBusinessObjectClass());
        }
        ArrayList<String> lookupFieldAttributeList = new ArrayList<String>();
        for (String lookupFieldName : lookupFieldNames) {
            if (this.getFieldsToIgnore().contains(lookupFieldName)) continue;
            lookupFieldAttributeList.add(lookupFieldName);
        }
        List fields = new ArrayList();
        try {
            fields = FieldUtils.createAndPopulateFieldsForLookup(lookupFieldAttributeList, (List)this.getReadOnlyFieldsList(), (Class)this.getBusinessObjectClass());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to create instance of business object class" + e.getMessage());
        }
        int numCols = this.getBusinessObjectDictionaryService().getLookupNumberOfColumns(this.getBusinessObjectClass());
        this.rows = FieldUtils.wrapFields(fields, (int)numCols);
    }

    protected List<String> getFieldsToIgnore() {
        ArrayList<String> fieldsToIgnore = new ArrayList<String>();
        if (!this.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            fieldsToIgnore.add("customerNumber");
        }
        return fieldsToIgnore;
    }

    public AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        return this.accountsReceivableModuleBillingService;
    }

    public void setAccountsReceivableModuleBillingService(AccountsReceivableModuleBillingService accountsReceivableModuleBillingService) {
        this.accountsReceivableModuleBillingService = accountsReceivableModuleBillingService;
    }
}

