/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import org.junit.Assert;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.module.cg.businessobject.defaultvalue.NextProposalNumberFinder;
import org.kuali.kfs.module.cg.document.ProposalAwardCloseDocument;
import org.kuali.kfs.module.cg.service.CloseService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CloseServiceTest
extends KualiTestBase {
    private static final String VALID_AWARD_STATUS_CODE = "R";
    private static final String INVALID_AWARD_STATUS_CODE = "U";
    private static final Long thirteen = 13L;
    private static final Long fourteen = 14L;
    private static final Long fifteen = 15L;
    private DateFormat dateFormat;
    private Date today;
    private Date tomorrow;

    protected void setUp() throws Exception {
        super.setUp();
        this.dateFormat = DateFormat.getDateInstance();
        this.today = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDateMidnight();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.today);
        calendar.add(6, 1);
        this.tomorrow = new Date(calendar.getTime().getTime());
    }

    public void testClose_awardEntryDateLessThanCloseOnOrBeforeDate() throws ParseException, WorkflowException {
        Date awardEntryDate = new Date(this.dateFormat.parse("May 20, 2000").getTime());
        Date proposalSubmissionDate = new Date(this.dateFormat.parse("May 2, 1999").getTime());
        Date proposalBeginningDate = new Date(this.dateFormat.parse("Jul 1, 1999").getTime());
        Date proposalEndingDate = new Date(this.dateFormat.parse("Aug 1, 1999").getTime());
        Date proposalClosingDate = null;
        Date awardClosingDate = null;
        Proposal proposal = this.createProposal(proposalBeginningDate, proposalEndingDate, proposalSubmissionDate, proposalClosingDate);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        Award award = this.createAward(proposal, awardEntryDate, awardClosingDate, VALID_AWARD_STATUS_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
        ProposalAwardCloseDocument close = this.createClose();
        this.saveAndRoute(close);
        this.verifyAwardWillBeIncludedInClose(award, close);
        this.verifyProposalWillBeIncludedInClose(proposal, close);
        ((CloseService)SpringContext.getBean(CloseService.class)).close();
        CloseServiceTest.assertEquals((String)"Awards were not closed properly.", (Object)fourteen, (Object)close.getAwardClosedCount());
        CloseServiceTest.assertEquals((String)"Proposals were not closed properly.", (Object)fifteen, (Object)close.getProposalClosedCount());
    }

    public void testClose_awardEntryDateEqualToCloseOnOrBeforeDate() throws ParseException, WorkflowException {
        Date awardEntryDate = new Date(this.dateFormat.parse("June 1, 2000").getTime());
        Date proposalSubmissionDate = new Date(this.dateFormat.parse("May 2, 1999").getTime());
        Date proposalBeginningDate = new Date(this.dateFormat.parse("Jul 1, 1999").getTime());
        Date proposalEndingDate = new Date(this.dateFormat.parse("Aug 1, 1999").getTime());
        Date proposalClosingDate = null;
        Date awardClosingDate = null;
        Proposal proposal = this.createProposal(proposalBeginningDate, proposalEndingDate, proposalSubmissionDate, proposalClosingDate);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        Award award = this.createAward(proposal, awardEntryDate, awardClosingDate, VALID_AWARD_STATUS_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
        ProposalAwardCloseDocument close = this.createClose();
        this.saveAndRoute(close);
        this.verifyAwardWillBeIncludedInClose(award, close);
        this.verifyProposalWillBeIncludedInClose(proposal, close);
        ((CloseService)SpringContext.getBean(CloseService.class)).close();
        CloseServiceTest.assertEquals((String)"Awards were not closed properly.", (Object)fourteen, (Object)close.getAwardClosedCount());
        CloseServiceTest.assertEquals((String)"Proposals were not closed properly.", (Object)fifteen, (Object)close.getProposalClosedCount());
    }

    public void testClose_awardClosingDateNotNull() throws ParseException, WorkflowException {
        Date awardEntryDate = new Date(this.dateFormat.parse("June 1, 2000").getTime());
        Date proposalSubmissionDate = new Date(this.dateFormat.parse("May 2, 1999").getTime());
        Date proposalBeginningDate = new Date(this.dateFormat.parse("Jul 1, 1999").getTime());
        Date proposalEndingDate = new Date(this.dateFormat.parse("Aug 1, 1999").getTime());
        Date proposalClosingDate = null;
        Date awardClosingDate = this.today;
        Proposal proposal = this.createProposal(proposalBeginningDate, proposalEndingDate, proposalSubmissionDate, proposalClosingDate);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        Award award = this.createAward(proposal, awardEntryDate, awardClosingDate, VALID_AWARD_STATUS_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
        ProposalAwardCloseDocument close = this.createClose();
        this.saveAndRoute(close);
        this.verifyAwardWillBeIncludedInClose(award, close, false, true, true);
        this.verifyProposalWillBeIncludedInClose(proposal, close);
        ((CloseService)SpringContext.getBean(CloseService.class)).close();
        CloseServiceTest.assertEquals((String)"Awards were not closed properly.", (Object)thirteen, (Object)close.getAwardClosedCount());
        CloseServiceTest.assertEquals((String)"Proposals were not closed properly.", (Object)fifteen, (Object)close.getProposalClosedCount());
    }

    public void testClose_awardStatusCodeInvalid() throws ParseException, WorkflowException {
        Date awardEntryDate = new Date(this.dateFormat.parse("June 1, 2000").getTime());
        Date proposalSubmissionDate = new Date(this.dateFormat.parse("May 2, 1999").getTime());
        Date proposalBeginningDate = new Date(this.dateFormat.parse("Jul 1, 1999").getTime());
        Date proposalEndingDate = new Date(this.dateFormat.parse("Aug 1, 1999").getTime());
        Date proposalClosingDate = null;
        Date awardClosingDate = null;
        Proposal proposal = this.createProposal(proposalBeginningDate, proposalEndingDate, proposalSubmissionDate, proposalClosingDate);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        Award award = this.createAward(proposal, awardEntryDate, awardClosingDate, INVALID_AWARD_STATUS_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
        ProposalAwardCloseDocument close = this.createClose();
        this.saveAndRoute(close);
        this.verifyAwardWillBeIncludedInClose(award, close, true, false, true);
        this.verifyProposalWillBeIncludedInClose(proposal, close);
        ((CloseService)SpringContext.getBean(CloseService.class)).close();
        CloseServiceTest.assertEquals((String)"Awards were not closed properly.", (Object)thirteen, (Object)close.getAwardClosedCount());
        CloseServiceTest.assertEquals((String)"Proposals were not closed properly.", (Object)fifteen, (Object)close.getProposalClosedCount());
    }

    public void testClose_awardEntryDateGreaterThanCloseOnOrBeforeDate() throws ParseException, WorkflowException {
        Date awardEntryDate = this.tomorrow;
        Date proposalSubmissionDate = new Date(this.dateFormat.parse("May 2, 1999").getTime());
        Date proposalBeginningDate = new Date(this.dateFormat.parse("Jul 1, 1999").getTime());
        Date proposalEndingDate = new Date(this.dateFormat.parse("Aug 1, 1999").getTime());
        Date proposalClosingDate = null;
        Date awardClosingDate = null;
        Proposal proposal = this.createProposal(proposalBeginningDate, proposalEndingDate, proposalSubmissionDate, proposalClosingDate);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        Award award = this.createAward(proposal, awardEntryDate, awardClosingDate, VALID_AWARD_STATUS_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
        ProposalAwardCloseDocument close = this.createClose();
        this.saveAndRoute(close);
        this.verifyAwardWillBeIncludedInClose(award, close, true, true, false);
        this.verifyProposalWillBeIncludedInClose(proposal, close);
        ((CloseService)SpringContext.getBean(CloseService.class)).close();
        CloseServiceTest.assertEquals((String)"Awards were not closed properly.", (Object)thirteen, (Object)close.getAwardClosedCount());
        CloseServiceTest.assertEquals((String)"Proposals were not closed properly.", (Object)fifteen, (Object)close.getProposalClosedCount());
    }

    public void testClose_proposalClosingDateNotNull() throws ParseException, WorkflowException {
        Date awardEntryDate = new Date(this.dateFormat.parse("June 1, 2000").getTime());
        Date proposalSubmissionDate = new Date(this.dateFormat.parse("May 2, 1999").getTime());
        Date proposalBeginningDate = new Date(this.dateFormat.parse("Jul 1, 1999").getTime());
        Date proposalEndingDate = new Date(this.dateFormat.parse("Aug 1, 1999").getTime());
        Date proposalClosingDate = this.today;
        Date awardClosingDate = null;
        Proposal proposal = this.createProposal(proposalBeginningDate, proposalEndingDate, proposalSubmissionDate, proposalClosingDate);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        Award award = this.createAward(proposal, awardEntryDate, awardClosingDate, VALID_AWARD_STATUS_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
        ProposalAwardCloseDocument close = this.createClose();
        this.saveAndRoute(close);
        this.verifyAwardWillBeIncludedInClose(award, close);
        this.verifyProposalWillBeIncludedInClose(proposal, close, false, true);
        ((CloseService)SpringContext.getBean(CloseService.class)).close();
        CloseServiceTest.assertEquals((String)"Awards were not closed properly.", (Object)fourteen, (Object)close.getAwardClosedCount());
        CloseServiceTest.assertEquals((String)"Proposals were not closed properly.", (Object)fourteen, (Object)close.getProposalClosedCount());
    }

    public void testClose_proposalSubmissionDateGreaterThanCloseCloseOnOrBeforeDate() throws ParseException, WorkflowException {
        Date awardEntryDate = new Date(this.dateFormat.parse("June 1, 2000").getTime());
        Date proposalSubmissionDate = this.tomorrow;
        Date proposalBeginningDate = new Date(this.dateFormat.parse("Jul 1, 1999").getTime());
        Date proposalEndingDate = new Date(this.dateFormat.parse("Aug 1, 1999").getTime());
        Date proposalClosingDate = null;
        Date awardClosingDate = null;
        Proposal proposal = this.createProposal(proposalBeginningDate, proposalEndingDate, proposalSubmissionDate, proposalClosingDate);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        Award award = this.createAward(proposal, awardEntryDate, awardClosingDate, VALID_AWARD_STATUS_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
        ProposalAwardCloseDocument close = this.createClose();
        this.saveAndRoute(close);
        this.verifyAwardWillBeIncludedInClose(award, close);
        this.verifyProposalWillBeIncludedInClose(proposal, close, true, false);
        ((CloseService)SpringContext.getBean(CloseService.class)).close();
        CloseServiceTest.assertEquals((String)"Awards were not closed properly.", (Object)fourteen, (Object)close.getAwardClosedCount());
        CloseServiceTest.assertEquals((String)"Proposals were not closed properly.", (Object)fourteen, (Object)close.getProposalClosedCount());
    }

    private void verifyAwardWillBeIncludedInClose(Award award, ProposalAwardCloseDocument close) {
        this.verifyAwardWillBeIncludedInClose(award, close, true, true, true);
    }

    private void verifyAwardWillBeIncludedInClose(Award award, ProposalAwardCloseDocument close, boolean verifyAwardClosingDate, boolean verifyAwardStatusCode, boolean verifyAwardEntryDate) {
        if (verifyAwardClosingDate) {
            CloseServiceTest.assertNull((String)"Award closing date must be null to be included in closing.", (Object)award.getAwardClosingDate());
        }
        if (verifyAwardStatusCode) {
            CloseServiceTest.assertNotSame((String)"Award status code must not be 'U' to be included in closing.", (Object)award.getAwardStatusCode(), (Object)INVALID_AWARD_STATUS_CODE);
        }
        if (verifyAwardEntryDate) {
            CloseServiceTest.assertTrue((String)"Award entry date must be less than or equal to the close last closed date.", (award.getAwardEntryDate().getTime() <= close.getCloseOnOrBeforeDate().getTime() ? 1 : 0) != 0);
        }
    }

    private void verifyProposalWillBeIncludedInClose(Proposal proposal, ProposalAwardCloseDocument close) {
        this.verifyProposalWillBeIncludedInClose(proposal, close, true, true);
    }

    private void verifyProposalWillBeIncludedInClose(Proposal proposal, ProposalAwardCloseDocument close, boolean verifyProposalClosingDate, boolean verifyProposalSubmissionDate) {
        if (verifyProposalClosingDate) {
            CloseServiceTest.assertNull((String)"Proposal closing date must be null to be included in closing.", (Object)proposal.getProposalClosingDate());
        }
        if (verifyProposalSubmissionDate) {
            CloseServiceTest.assertTrue((String)"Proposal submission date must be less than or equal to closing last closed date.", (proposal.getProposalSubmissionDate().getTime() <= close.getCloseOnOrBeforeDate().getTime() ? 1 : 0) != 0);
        }
    }

    private Proposal createProposal(Date proposalBeginningDate, Date proposalEndingDate, Date proposalSubmissionDate, Date proposalClosingDate) {
        Proposal proposal = new Proposal();
        proposal.setProposalNumber(NextProposalNumberFinder.getLongValue().toString());
        proposal.setAgencyNumber("12851");
        proposal.setProposalProjectTitle("Testing CG Close Process");
        proposal.setProposalBeginningDate(proposalBeginningDate);
        proposal.setProposalEndingDate(proposalEndingDate);
        proposal.setProposalDirectCostAmount(new KualiDecimal("3840.00"));
        proposal.setProposalIndirectCostAmount(new KualiDecimal("2016.00"));
        proposal.setProposalTotalAmount((KualiDecimal)proposal.getProposalDirectCostAmount().add((AbstractKualiDecimal)proposal.getProposalIndirectCostAmount()));
        proposal.setProposalSubmissionDate(proposalSubmissionDate);
        proposal.setProposalClosingDate(proposalClosingDate);
        proposal.setProposalAwardTypeCode("N");
        proposal.setProposalPurposeCode("C");
        return proposal;
    }

    private Award createAward(Proposal proposal, Date awardEntryDate, Date awardClosingDate, String awardStatusCode) {
        Award award = new Award(proposal);
        award.setAwardEntryDate(awardEntryDate);
        award.setAwardClosingDate(awardClosingDate);
        award.setAwardStatusCode(awardStatusCode);
        return award;
    }

    private ProposalAwardCloseDocument createClose() throws WorkflowException {
        Document document = DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), ProposalAwardCloseDocument.class);
        ProposalAwardCloseDocument close = (ProposalAwardCloseDocument)document;
        close.setUserInitiatedCloseDate(this.today);
        close.setCloseOnOrBeforeDate(this.today);
        return close;
    }

    private void saveAndRoute(ProposalAwardCloseDocument close) throws WorkflowException {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        CloseServiceTest.saveDocument((Document)close, documentService);
        close = (ProposalAwardCloseDocument)documentService.getByDocumentHeaderId(close.getDocumentNumber());
        CloseServiceTest.routeDocument((Document)close, documentService);
    }

    private static void routeDocument(Document document, DocumentService documentService) throws WorkflowException {
        Assert.assertNotEquals((String)("Document should not be already ENROUTE: " + document), (Object)DocumentStatus.ENROUTE, (Object)document.getDocumentHeader().getWorkflowDocument().getStatus());
        try {
            documentService.routeDocument(document, "routing test doc", new ArrayList());
        }
        catch (ValidationException e) {
            CloseServiceTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }

    private static void saveDocument(Document document, DocumentService documentService) throws WorkflowException {
        try {
            documentService.saveDocument(document);
        }
        catch (ValidationException e) {
            CloseServiceTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }
}

