/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.cg.batch.service.MaintenanceDocumentNotesMigrationService;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class MaintenanceDocumentNotesMigrationServiceImpl
implements MaintenanceDocumentNotesMigrationService {
    protected BusinessObjectService businessObjectService;
    protected IdentityService identityService;
    protected NoteService noteService;

    @Override
    public void moveAgencyMaintenanceDocumentNotesToBusinessObjects() {
        Principal systemUser = this.getSystemUser();
        Collection agencies = this.getBusinessObjectService().findAll(Agency.class);
        for (Agency agency : agencies) {
            this.migrateNotesForAgency(agency, systemUser);
        }
    }

    protected void migrateNotesForAgency(Agency agency, Principal systemUser) {
        List<DocumentHeader> documentHeaders = this.lookupDocumentHeaders("AGCY", agency.getAgencyNumber(), "agencyNumber", systemUser);
        for (DocumentHeader documentHeader : documentHeaders) {
            this.migrateNotes(documentHeader, (PersistableBusinessObject)agency);
        }
    }

    @Override
    public void moveAwardMaintenanceDocumentNotesToBusinessObjects() {
        Principal systemUser = this.getSystemUser();
        Collection awards = this.getBusinessObjectService().findAll(Award.class);
        for (Award award : awards) {
            this.migrateNotesForAward(award, systemUser);
        }
    }

    protected void migrateNotesForAward(Award award, Principal systemUser) {
        List<DocumentHeader> documentHeaders = this.lookupDocumentHeaders("AWRD", award.getProposalNumber(), "proposalNumber", systemUser);
        for (DocumentHeader documentHeader : documentHeaders) {
            this.migrateNotes(documentHeader, (PersistableBusinessObject)award);
        }
    }

    protected List<DocumentHeader> lookupDocumentHeaders(String maintenanceDocumentType, String primaryKey, String primaryKeyField, Principal systemUser) {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(maintenanceDocumentType);
        criteria.addDocumentAttributeValue(primaryKeyField, primaryKey);
        DocumentSearchCriteria crit = criteria.build();
        return this.retrieveDocuments(crit, systemUser);
    }

    protected List<DocumentHeader> retrieveDocuments(DocumentSearchCriteria criteria, Principal systemUser) {
        DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(systemUser.getPrincipalId(), criteria);
        ArrayList<DocumentHeader> documentHeaders = new ArrayList<DocumentHeader>();
        for (DocumentSearchResult result : results.getSearchResults()) {
            DocumentHeader docHeader = (DocumentHeader)this.getBusinessObjectService().findBySinglePrimaryKey(DocumentHeader.class, (Object)result.getDocument().getDocumentId());
            documentHeaders.add(docHeader);
        }
        return documentHeaders;
    }

    protected void migrateNotes(DocumentHeader documentHeader, PersistableBusinessObject businessObject) {
        List notes = this.getNoteService().getByRemoteObjectId(documentHeader.getObjectId());
        if (!CollectionUtils.isEmpty((Collection)notes)) {
            for (Note note : notes) {
                note.setRemoteObjectIdentifier(businessObject.getObjectId());
                this.getNoteService().save(note);
            }
        }
    }

    protected Principal getSystemUser() {
        return this.getIdentityService().getPrincipalByPrincipalName("kfs");
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }
}

