/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.document.validation.impl.MaintenancePreRulesBase;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardPreRules
extends MaintenancePreRulesBase {
    protected AccountsReceivableModuleBillingService accountsReceivableModuleBillingService = (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
    protected DataDictionaryService dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
    protected Award newAward;

    protected boolean doCustomPreRules(MaintenanceDocument document) {
        this.setupConvenienceObjects(document);
        boolean proceed = this.continueIfEntryDateBeforeBeginDate();
        if (proceed) {
            proceed = this.continueIfSubcontractorTotalGreaterThanAwardTotal();
        }
        if (proceed && this.accountsReceivableModuleBillingService.isContractsGrantsBillingEnhancementActive()) {
            proceed = this.continueIfAwardTotalAmountLessThanScheduledAmount();
        }
        if (!proceed) {
            this.abortRulesCheck();
        }
        return true;
    }

    protected boolean continueIfEntryDateBeforeBeginDate() {
        boolean proceed = true;
        Date entryDate = this.newAward.getAwardEntryDate();
        Date beginDate = this.newAward.getAwardBeginningDate();
        if (ObjectUtils.isNotNull((Object)entryDate) && ObjectUtils.isNotNull((Object)beginDate) && entryDate.before(beginDate)) {
            String entryDateLabel = this.dataDictionaryService.getAttributeErrorLabel(Award.class, "awardEntryDate");
            String beginDateLabel = this.dataDictionaryService.getAttributeErrorLabel(Award.class, "awardBeginningDate");
            proceed = this.askOrAnalyzeYesNoQuestion("entryDateBeforeStartDateQuestion", MessageFormat.format(this.configService.getPropertyValueAsString("warning.cg.award.entryDateBeforeStartDate"), entryDateLabel, beginDateLabel));
        }
        return proceed;
    }

    protected boolean continueIfSubcontractorTotalGreaterThanAwardTotal() {
        boolean proceed = true;
        KualiDecimal awardTotal = this.newAward.getAwardTotalAmount();
        KualiDecimal subcontractorTotal = this.newAward.getAwardSubcontractorsTotalAmount();
        if (ObjectUtils.isNotNull((Object)awardTotal) && subcontractorTotal.isGreaterThan((AbstractKualiDecimal)awardTotal) || ObjectUtils.isNull((Object)awardTotal) && subcontractorTotal.isPositive()) {
            String subcontractorLabel = this.dataDictionaryService.getCollectionLabel(Award.class, "awardSubcontractors");
            String awardLabel = this.dataDictionaryService.getAttributeErrorLabel(Award.class, "awardTotalAmount");
            proceed = this.askOrAnalyzeYesNoQuestion("subcontractorTotalGreaterThanAwardTotalQuestion", MessageFormat.format(this.configService.getPropertyValueAsString("warning.cg.award.subcontractorAmountGreaterThanAwardAmount"), subcontractorLabel, awardLabel));
        }
        return proceed;
    }

    protected boolean continueIfAwardTotalAmountLessThanScheduledAmount() {
        KualiDecimal billTotal;
        KualiDecimal milestoneTotal;
        KualiDecimal newAwardTotalAmount = this.newAward.getAwardTotalAmount();
        if (StringUtils.equals((CharSequence)this.newAward.getBillingFrequencyCode(), (CharSequence)"MILE") && newAwardTotalAmount.isLessThan((AbstractKualiDecimal)(milestoneTotal = ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).getMilestonesTotalAmount(this.newAward.getProposalNumber())))) {
            return this.askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", MessageFormat.format(this.configService.getPropertyValueAsString("warning.cg.award.totalAwardAmountLessThanScheduleAmount"), "Milestone"));
        }
        if (StringUtils.equals((CharSequence)this.newAward.getBillingFrequencyCode(), (CharSequence)"PDBS") && newAwardTotalAmount.isLessThan((AbstractKualiDecimal)(billTotal = ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).getBillsTotalAmount(this.newAward.getProposalNumber())))) {
            return this.askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", MessageFormat.format(this.configService.getPropertyValueAsString("warning.cg.award.totalAwardAmountLessThanScheduleAmount"), "Predetermined Billing"));
        }
        return true;
    }

    protected void setupConvenienceObjects(MaintenanceDocument document) {
        this.newAward = (Award)document.getNewMaintainableObject().getBusinessObject();
    }
}

