/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.businessobject.AgencyType;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;

public class AgencyRule
extends CGMaintenanceDocumentRuleBase {
    protected static Logger LOG = LogManager.getLogger(AgencyRule.class);
    protected Agency newAgency;
    protected Agency oldAgency;
    BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering AgencyRule.processCustomApproveDocumentBusinessRules");
        boolean success = super.processCustomApproveDocumentBusinessRules(document);
        LOG.info("Leaving AgencyRule.processCustomApproveDocumentBusinessRules");
        return success &= this.checkAgencyReportsTo(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering AgencyRule.processCustomRouteDocumentBusinessRules");
        boolean success = super.processCustomRouteDocumentBusinessRules(document);
        success &= this.checkAgencyReportsTo(document);
        if (this.contractsGrantsBillingEnhancementActive) {
            if ("C".equals(this.newAgency.getCustomerCreationOptionCode())) {
                success &= this.checkPrimary(this.newAgency.getAgencyAddresses(), AgencyAddress.class, "agencyAddresses", Agency.class);
            }
            success &= this.validateAddresses(this.newAgency);
            success &= this.validateCustomerType(this.newAgency);
        }
        LOG.info("Leaving AgencyRule.processCustomRouteDocumentBusinessRules");
        return success;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering AgencyRule.processCustomSaveDocumentBusinessRules");
        boolean success = super.processCustomSaveDocumentBusinessRules(document);
        success &= this.checkAgencyReportsTo(document);
        success &= this.validateAgencyType(document);
        LOG.info("Leaving AgencyRule.processCustomSaveDocumentBusinessRules");
        return success &= this.validateAgencyReportingName(document);
    }

    protected boolean validateAgencyType(MaintenanceDocument document) {
        String agencyType = this.newAgency.getAgencyTypeCode();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", agencyType);
        BusinessObject o = this.businessObjectService.findByPrimaryKey(AgencyType.class, params);
        if (null == o) {
            this.putFieldError("agencyTypeCode", "error.cg.agencyTypeNotFound", agencyType);
            return false;
        }
        return true;
    }

    protected boolean validateAgencyReportingName(MaintenanceDocument document) {
        String agencyReportingName = this.newAgency.getReportingName();
        String agencyExistsValue = this.newAgency.getCustomerCreationOptionCode();
        if ("C".equalsIgnoreCase(agencyExistsValue)) {
            if (agencyReportingName.length() < 3) {
                this.putFieldError("reportingName", "error.document.agency.agencyNameLessThanThreeCharacters");
                return false;
            }
            if (agencyReportingName.substring(0, 3).contains(" ")) {
                this.putFieldError("reportingName", "error.document.agency.agencyNameNoSpacesInFirstThreeCharacters");
                return false;
            }
        }
        return true;
    }

    protected boolean checkAgencyReportsTo(MaintenanceDocument document) {
        boolean success = true;
        if (this.newAgency.getReportsToAgencyNumber() != null) {
            if (this.newAgency.getReportsToAgency() == null) {
                this.putFieldError("reportsToAgencyNumber", "error.cg.agencyNotFound", this.newAgency.getReportsToAgencyNumber());
                success = false;
            } else if (!this.newAgency.getReportsToAgency().isActive()) {
                this.putFieldError("reportsToAgencyNumber", "error.cg.agenyInactive", this.newAgency.getReportsToAgencyNumber());
                success = false;
            } else if (this.newAgency.getAgencyNumber().equals(this.newAgency.getReportsToAgencyNumber())) {
                this.putFieldError("reportsToAgencyNumber", "error.cg.agencyReportsToSelf", this.newAgency.getAgencyNumber());
                success = false;
            } else {
                ArrayList<String> agencies = new ArrayList<String>();
                Agency agency = this.newAgency;
                while (agency.getReportsToAgency() != null && success) {
                    if (!agencies.contains(agency.getAgencyNumber())) {
                        agencies.add(agency.getAgencyNumber());
                    } else {
                        this.putFieldError("reportsToAgencyNumber", "error.cg.agencyCircularReporting", agency.getAgencyNumber());
                        success = false;
                    }
                    agency = agency.getReportsToAgency();
                }
            }
        }
        return success;
    }

    public void setupConvenienceObjects() {
        this.newAgency = (Agency)((Object)super.getNewBo());
        this.oldAgency = (Agency)((Object)super.getOldBo());
    }

    public boolean processAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        if (this.contractsGrantsBillingEnhancementActive && line instanceof AgencyAddress) {
            AgencyAddress newAgencyAddress = (AgencyAddress)line;
            if (collectionName.equals("agencyAddresses")) {
                this.newAgency = (Agency)document.getNewMaintainableObject().getBusinessObject();
                List<AgencyAddress> agencyAddresses = this.newAgency.getAgencyAddresses();
                String tmpCode = newAgencyAddress.getCustomerAddressTypeCode();
                for (AgencyAddress agencyAddress : agencyAddresses) {
                    String customerAddressTypeCode = agencyAddress.getCustomerAddressTypeCode();
                    if (customerAddressTypeCode == null || !customerAddressTypeCode.equals("P")) continue;
                    if (ObjectUtils.isNotNull((Object)tmpCode) && !tmpCode.isEmpty() && tmpCode.equals("P")) {
                        String elementLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getCollectionElementLabel(Agency.class.getName(), collectionName, AgencyAddress.class);
                        this.putFieldError(collectionName, "error.cg.multiplePrimary", elementLabel);
                        return false;
                    }
                    boolean isValid = this.checkAddressIsValid(newAgencyAddress);
                    if (isValid) continue;
                    return false;
                }
            }
        }
        return super.processAddCollectionLineBusinessRules(document, collectionName, line);
    }

    public boolean checkAddressIsValid(AgencyAddress agencyAddress) {
        boolean isValid = true;
        if ("C".equalsIgnoreCase(this.newAgency.getCustomerCreationOptionCode())) {
            if ("US".equalsIgnoreCase(agencyAddress.getAgencyCountryCode())) {
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyZipCode())) {
                    isValid = false;
                    GlobalVariables.getMessageMap().putError("agencyZipCode", "error.document.agency.zipCodeIsRequiredWhenCountryUS", new String[0]);
                }
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyStateCode())) {
                    isValid = false;
                    GlobalVariables.getMessageMap().putError("agencyStateCode", "error.document.agency.stateCodeIsRequiredWhenCountryUS", new String[0]);
                }
            } else {
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyInternationalMailCode())) {
                    isValid = false;
                    GlobalVariables.getMessageMap().putError("agencyInternationalMailCode", "error.document.agency.internationalMailCodeIsRequiredWhenCountryNonUS", new String[0]);
                }
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyAddressInternationalProvinceName())) {
                    isValid = false;
                    GlobalVariables.getMessageMap().putError("agencyAddressInternationalProvinceName", "error.document.agency.addressInternationalProvinceNameIsRequiredWhenCountryNonUS", new String[0]);
                }
            }
        }
        return isValid;
    }

    public boolean checkAddressIsValid(AgencyAddress agencyAddress, int ind) {
        boolean isValid = true;
        String propertyName = "agencyAddresses[" + ind + "].";
        if ("C".equalsIgnoreCase(this.newAgency.getCustomerCreationOptionCode())) {
            if ("US".equalsIgnoreCase(agencyAddress.getAgencyCountryCode())) {
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyZipCode())) {
                    isValid = false;
                    this.putFieldError(propertyName + "agencyZipCode", "error.document.agency.zipCodeIsRequiredWhenCountryUS");
                }
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyStateCode())) {
                    isValid = false;
                    this.putFieldError(propertyName + "agencyStateCode", "error.document.agency.stateCodeIsRequiredWhenCountryUS");
                }
            } else {
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyInternationalMailCode())) {
                    isValid = false;
                    this.putFieldError(propertyName + "agencyInternationalMailCode", "error.document.agency.internationalMailCodeIsRequiredWhenCountryNonUS");
                }
                if (StringUtils.isBlank((CharSequence)agencyAddress.getAgencyAddressInternationalProvinceName())) {
                    isValid = false;
                    this.putFieldError(propertyName + "agencyAddressInternationalProvinceName", "error.document.agency.addressInternationalProvinceNameIsRequiredWhenCountryNonUS");
                }
            }
        }
        return isValid;
    }

    public boolean validateAddresses(Agency agency) {
        boolean isValid = true;
        int i = 0;
        for (AgencyAddress agencyAddress : agency.getAgencyAddresses()) {
            isValid &= this.checkAddressIsValid(agencyAddress, i);
            ++i;
        }
        return isValid;
    }

    public boolean validateCustomerType(Agency agency) {
        boolean isValid = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)agency.getCustomerCreationOptionCode())) {
            if (StringUtils.isEmpty((CharSequence)agency.getCustomerTypeCode())) {
                this.putFieldError("customerTypeCode", "error.document.agency.customerTypeCodeisRequiredWhenNewCustomer");
                isValid = false;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"E", (CharSequence)agency.getCustomerCreationOptionCode())) {
            if (StringUtils.isBlank((CharSequence)agency.getCustomerNumber())) {
                this.putFieldError("customerNumber", "error.document.agency.customerNumberRequiredWhenExistingCustomer");
                isValid = false;
            } else {
                AccountsReceivableCustomer customer = agency.getCustomer();
                if (ObjectUtils.isNull((Object)customer) || !customer.isActive()) {
                    this.putFieldError("customerNumber", "error.document.agency.actualCustomerRequiredWhenExistingCustomer", new String[]{agency.getCustomerNumber()});
                    isValid = false;
                }
            }
        }
        return isValid;
    }
}

