/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import org.junit.Before;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.document.validation.impl.AgencyRule;
import org.kuali.kfs.module.cg.fixture.AgencyFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@ConfigureContext(session=UserNameFixture.khuntley)
public class AgencyRuleTest
extends MaintenanceRuleTestBase {
    @Mock
    MaintenanceDocument documentMock;
    private AgencyRule rule;
    private Agency agency;
    private AgencyAddress agencyAddress;
    private BusinessObjectService boService;
    private Long agencyNumber;
    private static final String AGENCY_ADDRESS_NAME = "Address Name";
    private static final String AGENCY_ADDRESS_COUNTRY_CODE_US = "US";
    private static final String AGENCY_ADDRESS_COUNTRY_CODE_RO = "RO";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.agencyNumber = 12500L;
        this.agency = new Agency();
        this.agencyAddress = new AgencyAddress();
        this.rule = (AgencyRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.agency), AgencyRule.class);
    }

    public void testCheckAgencyReportsTo_True() {
        this.agency = (Agency)this.boService.findBySinglePrimaryKey(Agency.class, (Object)this.agencyNumber);
        AgencyRuleTest.assertTrue((boolean)this.rule.checkAgencyReportsTo(this.newMaintDoc((PersistableBusinessObject)this.agency)));
    }

    public void testValidateAgencyType_True() {
        this.rule.newAgency = this.agency = AgencyFixture.CG_AGENCY1.createAgency();
        AgencyRuleTest.assertTrue((boolean)this.rule.validateAgencyType(this.newMaintDoc((PersistableBusinessObject)this.agency)));
    }

    public void testValidateAgencyReportingName_True() {
        this.rule.newAgency = this.agency = AgencyFixture.CG_AGENCY1.createAgency();
        AgencyRuleTest.assertTrue((boolean)this.rule.validateAgencyReportingName(this.newMaintDoc((PersistableBusinessObject)this.agency)));
    }

    public void testCheckAddressIsValid_CountryUS_False() {
        this.agencyAddress.setAgencyAddressName(AGENCY_ADDRESS_NAME);
        this.agencyAddress.setAgencyCountryCode(AGENCY_ADDRESS_COUNTRY_CODE_US);
        this.agencyAddress.setAgencyStateCode("");
        this.agencyAddress.setAgencyZipCode("");
        this.agency.setCustomerCreationOptionCode("C");
        AgencyRule rule = (AgencyRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.agency), AgencyRule.class);
        rule.newAgency = this.agency;
        boolean result = rule.checkAddressIsValid(this.agencyAddress);
        AgencyRuleTest.assertFalse((String)"When agency address has country code US and state code and zip code are empty checkAddressIsValid should return false. ", (boolean)result);
    }

    public void testCheckAddressIsValid_CountryNonUS_False() {
        this.agencyAddress.setAgencyAddressName(AGENCY_ADDRESS_NAME);
        this.agencyAddress.setAgencyCountryCode(AGENCY_ADDRESS_COUNTRY_CODE_RO);
        this.agencyAddress.setAgencyAddressInternationalProvinceName("");
        this.agencyAddress.setAgencyZipCode("");
        this.agency.setCustomerCreationOptionCode("C");
        AgencyRule rule = (AgencyRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.agency), AgencyRule.class);
        rule.newAgency = this.agency;
        boolean result = rule.checkAddressIsValid(this.agencyAddress);
        AgencyRuleTest.assertFalse((String)"When agency address has country code RO and province and International Mail Code are empty checkAddressIsValid should return false. ", (boolean)result);
    }

    public void testProcessCustomRouteDocumentBusinessRules_newCustomer_primaryAddressRequired() {
        this.agency.setCustomerCreationOptionCode("C");
        this.rule.newAgency = this.agency;
        this.rule.contractsGrantsBillingEnhancementActive = true;
        AgencyRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(this.documentMock));
    }

    public void testProcessCustomRouteDocumentBusinessRules_existingCustomer_primaryAddressNotRequired() {
        AccountsReceivableCustomer customerMock = (AccountsReceivableCustomer)Mockito.mock(AccountsReceivableCustomer.class);
        Mockito.when((Object)customerMock.isActive()).thenReturn((Object)true);
        this.agency.setCustomerCreationOptionCode("E");
        this.agency.setCustomerTypeCode("01");
        this.agency.setCustomerNumber("0123456");
        this.agency.setCustomer(customerMock);
        this.rule.newAgency = this.agency;
        this.rule.contractsGrantsBillingEnhancementActive = true;
        AgencyRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(this.documentMock));
    }

    public void testProcessCustomRouteDocumentBusinessRules_noCustomer_primaryAddressNotRequired() {
        this.agency.setCustomerCreationOptionCode("N");
        this.rule.newAgency = this.agency;
        this.rule.contractsGrantsBillingEnhancementActive = true;
        AgencyRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(this.documentMock));
    }
}

