/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.businessobject.BillingFrequency;
import org.kuali.kfs.integration.cg.CGIntegrationConstants;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.businessobject.SubContractor;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRule;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRuleUtil;
import org.kuali.kfs.module.cg.fixture.AwardFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.util.AutoPopulatingList;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AwardRuleUtil.class, SpringContext.class})
public class AwardRuleTest {
    private static final String AWARD_ACCOUNTS_LABEL = "Award Accounts";
    private static final String BILLING_FREQUENCY_LABEL = "Billing Frequency";
    private static final String INVOICING_OPTION_LABEL = "Invoicing Option";
    private AwardRule cutSpy;
    @Mock
    private AccountsReceivableModuleBillingService accountsReceivableModuleBillingSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private DictionaryValidationService dictionaryValidationSvcMock;
    private Award award;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        PowerMockito.mockStatic(AwardRuleUtil.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        PowerMockito.when((Object)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
        PowerMockito.when((Object)this.dataDictionarySvcMock.getCollectionElementLabel(Award.class.getName(), "awardAccounts", AwardAccount.class)).thenReturn((Object)AWARD_ACCOUNTS_LABEL);
        PowerMockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(Award.class, "billingFrequencyCode")).thenReturn((Object)BILLING_FREQUENCY_LABEL);
        PowerMockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(Award.class, "invoicingOptionCode")).thenReturn((Object)INVOICING_OPTION_LABEL);
        this.cutSpy = (AwardRule)PowerMockito.spy((Object)new AwardRule());
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        PowerMockito.doReturn((Object)this.dataDictionarySvcMock).when((Object)this.cutSpy, "getDataDictionaryService", new Object[0]);
        this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    @Test
    public void checkAccounts_NoAwardAccounts() {
        this.cutSpy.newAwardCopy = new Award();
        Assert.assertFalse((boolean)this.cutSpy.checkAccounts());
    }

    @Test
    public void checkAccounts_HasAwardAccounts() {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        AwardAccount awardAccount = new AwardAccount();
        awardAccounts.add(awardAccount);
        this.award.setAwardAccounts(awardAccounts);
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.checkAccounts());
    }

    @Test
    public void checkProposal_ProposalHasBeenAwarded() {
        PowerMockito.when((Object)AwardRuleUtil.isProposalAwarded((Award)this.award)).thenReturn((Object)true);
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertFalse((boolean)this.cutSpy.checkProposal());
    }

    @Test
    public void checkProposal_ProposalHasNotBeenAwarded() {
        PowerMockito.when((Object)AwardRuleUtil.isProposalAwarded((Award)this.award)).thenReturn((Object)false);
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.checkProposal());
    }

    @Test
    public void checkFederalPassThrough_NotFederalPassThrough() {
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.checkFederalPassThrough());
    }

    @Test
    public void checkFederalPassThrough_FederalPassThroughIndicatorIsYes_NoAgencyNumber() {
        this.award.setFederalPassThroughIndicator(true);
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertFalse((boolean)this.cutSpy.checkFederalPassThrough());
    }

    @Test
    public void checkFederalPassThrough_FederalPassThrough_AgencyNumberPopulated() {
        this.award.setFederalPassThroughIndicator(true);
        this.award.setFederalPassThroughAgencyNumber("12345");
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.checkFederalPassThrough());
    }

    @Test
    public void checkAwardOrganization() {
        AwardOrganization awardOrganization = (AwardOrganization)Mockito.spy(AwardOrganization.class);
        awardOrganization.setOrganizationCode("PSY");
        awardOrganization.setChartOfAccountsCode("BL");
        awardOrganization.setOrganization(new Organization());
        this.award.setPrimaryAwardOrganization(awardOrganization);
        ((AwardOrganization)Mockito.doNothing().when((Object)awardOrganization)).refreshReferenceObject("organization");
        Assert.assertTrue((boolean)this.cutSpy.checkAwardOrganization(this.award.getPrimaryAwardOrganization()));
    }

    @Test
    public void checkAwardSubcontractor() {
        ArrayList<AwardSubcontractor> awardSubcontractors = new ArrayList<AwardSubcontractor>();
        AwardSubcontractor awardSubcontractor = (AwardSubcontractor)Mockito.spy(AwardSubcontractor.class);
        awardSubcontractor.setSubcontractorNumber("12345");
        awardSubcontractor.setSubcontractor(new SubContractor());
        awardSubcontractors.add(awardSubcontractor);
        this.award.setAwardSubcontractors(awardSubcontractors);
        ((AwardSubcontractor)Mockito.doNothing().when((Object)awardSubcontractor)).refreshReferenceObject("subcontractor");
        Assert.assertTrue((boolean)this.cutSpy.checkAwardSubcontractor((AwardSubcontractor)this.award.getAwardSubcontractors().get(0)));
    }

    @Test
    public void checkAwardAccount() {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        AwardAccount awardAccount = (AwardAccount)Mockito.spy(AwardAccount.class);
        awardAccount.setChartOfAccountsCode("BL");
        awardAccount.setAccountNumber("0211821");
        awardAccount.setPrincipalId("5334003983");
        Account account = new Account();
        account.setChartOfAccountsCode("BL");
        account.setAccountNumber("0211821");
        awardAccount.setAccount(account);
        Person projectDirectorMock = (Person)Mockito.mock(Person.class);
        awardAccount.setProjectDirector(projectDirectorMock);
        awardAccounts.add(awardAccount);
        this.award.setAwardAccounts(awardAccounts);
        ((AwardAccount)Mockito.doNothing().when((Object)awardAccount)).refreshReferenceObject("account");
        ((AwardAccount)Mockito.doReturn((Object)projectDirectorMock).when((Object)awardAccount)).getProjectDirector();
        Assert.assertTrue((boolean)this.cutSpy.checkAwardAccount((AwardAccount)this.award.getAwardAccounts().get(0)));
    }

    @Test
    public void checkAwardProjectDirector() {
        ArrayList<AwardProjectDirector> awardProjectDirectors = new ArrayList<AwardProjectDirector>();
        AwardProjectDirector awardProjectDirector = (AwardProjectDirector)Mockito.spy(AwardProjectDirector.class);
        awardProjectDirector.setPrincipalId("5334003983");
        Person projectDirectorMock = (Person)Mockito.mock(Person.class);
        awardProjectDirector.setProjectDirector(projectDirectorMock);
        awardProjectDirectors.add(awardProjectDirector);
        this.award.setAwardProjectDirectors(awardProjectDirectors);
        ((AwardProjectDirector)Mockito.doReturn((Object)projectDirectorMock).when((Object)awardProjectDirector)).getProjectDirector();
        Assert.assertTrue((boolean)this.cutSpy.checkAwardProjectDirector((AwardProjectDirector)this.award.getAwardProjectDirectors().get(0)));
    }

    @Test
    public void checkAwardFundManager() {
        this.award.setAwardFundManagers(this.setupAwardFundManagers());
        Assert.assertTrue((boolean)this.cutSpy.checkAwardFundManager((AwardFundManager)this.award.getAwardFundManagers().get(0)));
    }

    @Test
    public void checkExcludedFromInvoicing() {
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.checkExcludedFromInvoicing());
    }

    @Test
    public void checkInvoicingOption() {
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.checkInvoicingOption());
    }

    @Test
    public void checkInvoicingOption_ContractControlAccountNotSetup() {
        this.cutSpy.newAwardCopy = this.award;
        PowerMockito.when((Object)this.accountsReceivableModuleBillingSvcMock.checkAwardContractControlAccounts((ContractsAndGrantsBillingAward)this.award)).thenReturn(Arrays.asList("errorKey", this.award.getInvoicingOptionDescription()));
        Assert.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assert.assertEquals((Object)"errorKey", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)this.award.getInvoicingOptionDescription(), (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void checkInvoicingOption_InvalidInvoicingOption_MonthlyBillingFrequency_ScheduleInvoicingOption() {
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Monthly");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getCode());
        Assert.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assert.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)2L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assert.assertEquals((Object)"Monthly", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    public void checkInvoicingOption_MilestoneBillingFrequency_AccountInvoicingOption() {
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Milestone");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.ACCOUNT.getCode());
        Assert.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assert.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)2L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.ACCOUNT.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assert.assertEquals((Object)"Milestone", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    public void checkInvoicingOption_MilestoneBillingFrequency_AwardInvoicingOption() {
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Milestone");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.AWARD.getCode());
        Assert.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assert.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)2L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.AWARD.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assert.assertEquals((Object)"Milestone", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    public void checkInvoicingOption_PredeterminedBillingFrequency_ContractControlAccountInvoicingOption() {
        this.award.setBillingFrequencyCode("PDBS");
        this.cutSpy.newAwardCopy = this.award;
        BillingFrequency billingFrequency = new BillingFrequency();
        billingFrequency.setFrequency(this.award.getBillingFrequencyCode());
        billingFrequency.setFrequencyDescription("Predetermined Billing");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.CONTRACT_CONTROL.getCode());
        Assert.assertFalse((boolean)this.cutSpy.checkInvoicingOption());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode")).get(0);
        Assert.assertEquals((Object)"error.cg.invalid.invoicing.option", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)2L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)CGIntegrationConstants.AwardInvoicingOption.Types.CONTRACT_CONTROL.getName(), (Object)errorMessage.getMessageParameters()[0]);
        Assert.assertEquals((Object)"Predetermined Billing", (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    public void checkConditionallyRequiredFields_BillingFrequencyEnteredInvoicingOptionMissing() {
        this.cutSpy.newAwardCopy = this.award;
        this.award.setBillingFrequencyCode("MNTH");
        this.award.setInvoicingOptionCode(null);
        Assert.assertFalse((boolean)this.cutSpy.checkConditionallyRequiredFields());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.invoicingOptionCode");
        Assert.assertNotNull((Object)errorMessages);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.cg.billing.frequency.and.invoicing.option.required", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)2L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)INVOICING_OPTION_LABEL, (Object)errorMessage.getMessageParameters()[0]);
        Assert.assertEquals((Object)BILLING_FREQUENCY_LABEL, (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    public void checkConditionallyRequiredFields_InvoicingOptionEnteredBillingFrequencyMissing() {
        this.cutSpy.newAwardCopy = this.award;
        this.award.setBillingFrequencyCode(null);
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.ACCOUNT.getCode());
        Assert.assertFalse((boolean)this.cutSpy.checkConditionallyRequiredFields());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.billingFrequencyCode");
        Assert.assertNotNull((Object)errorMessages);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.cg.billing.frequency.and.invoicing.option.required", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)2L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)BILLING_FREQUENCY_LABEL, (Object)errorMessage.getMessageParameters()[0]);
        Assert.assertEquals((Object)INVOICING_OPTION_LABEL, (Object)errorMessage.getMessageParameters()[1]);
    }

    @Test
    public void checkBillingFrequency_noChange() {
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        Assert.assertTrue((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    public void checkBillingFrequency_frequencyChangeToMilestone_noActiveMilestones() {
        this.cutSpy.oldAwardCopy = this.award;
        Award awardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.newAwardCopy = awardCopy;
        Assert.assertTrue((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    public void checkBillingFrequency_frequencyChangeToPredeterminedBilling_noActiveBills() {
        this.cutSpy.oldAwardCopy = this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        Award awardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        this.award.setBillingFrequencyCode("PDBS");
        this.cutSpy.newAwardCopy = awardCopy;
        Assert.assertTrue((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    public void checkBillingFrequency_frequencyChangeToMilestone_activeUnbilledMilestones() {
        Award awardCopy = this.setupAwardCopy();
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = awardCopy;
        this.award.setBillingFrequencyCode("MILE");
        PowerMockito.when((Object)this.accountsReceivableModuleBillingSvcMock.hasActiveUnbilledMilestones(awardCopy.getProposalNumber(), "BL", "0211821")).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    public void checkBillingFrequency_frequencyChangeToMilestone_activeUnbilledBills() {
        Award awardCopy = this.setupAwardCopy();
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = awardCopy;
        this.award.setBillingFrequencyCode("PDBS");
        PowerMockito.when((Object)this.accountsReceivableModuleBillingSvcMock.hasActiveUnbilledBills(awardCopy.getProposalNumber(), "BL", "0211821")).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cutSpy.checkBillingFrequency());
    }

    @Test
    public void performContractsGrantsBillingChecks_Milestone_hasMultipleAccounts() {
        this.award.setBillingFrequencyCode("MILE");
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getCode());
        this.award.setAwardFundManagers(this.setupAwardFundManagers());
        BillingFrequency billingFrequency = (BillingFrequency)Mockito.mock(BillingFrequency.class);
        PowerMockito.when((Object)billingFrequency.getFrequency()).thenReturn((Object)"MILE");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setAwardAccounts(this.setupAwardAccounts());
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.performContractsGrantsBillingChecks());
    }

    @Test
    public void performContractsGrantsBillingChecks_PredeterminedBilling_hasMultipleAccounts() {
        this.award.setBillingFrequencyCode("PDBS");
        this.award.setInvoicingOptionCode(CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getCode());
        this.award.setAwardFundManagers(this.setupAwardFundManagers());
        BillingFrequency billingFrequency = (BillingFrequency)Mockito.mock(BillingFrequency.class);
        PowerMockito.when((Object)billingFrequency.getFrequency()).thenReturn((Object)"PDBS");
        this.award.setBillingFrequency((AccountsReceivableBillingFrequency)billingFrequency);
        this.award.setAwardAccounts(this.setupAwardAccounts());
        this.cutSpy.oldAwardCopy = this.award;
        this.cutSpy.newAwardCopy = this.award;
        Assert.assertTrue((boolean)this.cutSpy.performContractsGrantsBillingChecks());
    }

    public List<AwardFundManager> setupAwardFundManagers() {
        ArrayList<AwardFundManager> awardFundManagers = new ArrayList<AwardFundManager>();
        AwardFundManager awardFundManager = (AwardFundManager)Mockito.spy(AwardFundManager.class);
        awardFundManager.setPrincipalId("5334003983");
        awardFundManager.setPrimaryFundManagerIndicator(true);
        Person fundManagerMock = (Person)Mockito.mock(Person.class);
        awardFundManager.setFundManager(fundManagerMock);
        awardFundManagers.add(awardFundManager);
        ((AwardFundManager)Mockito.doReturn((Object)fundManagerMock).when((Object)awardFundManager)).getFundManager();
        return awardFundManagers;
    }

    private Award setupAwardCopy() {
        Award awardCopy = (Award)ObjectUtils.deepCopy((Serializable)this.award);
        List<AwardAccount> awardAccounts = this.setupAwardAccounts();
        awardCopy.setAwardAccounts(awardAccounts);
        AccountsReceivableBillingFrequency billingFrequencyMock = (AccountsReceivableBillingFrequency)Mockito.mock(AccountsReceivableBillingFrequency.class);
        PowerMockito.when((Object)billingFrequencyMock.getFrequency()).thenReturn((Object)awardCopy.getBillingFrequencyCode());
        awardCopy.setBillingFrequency(billingFrequencyMock);
        return awardCopy;
    }

    private List<AwardAccount> setupAwardAccounts() {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(this.setupAwardAccount("0211821"));
        awardAccounts.add(this.setupAwardAccount("0211822"));
        return awardAccounts;
    }

    private AwardAccount setupAwardAccount(String accountNumber) {
        AwardAccount awardAccount = (AwardAccount)Mockito.spy(AwardAccount.class);
        awardAccount.setChartOfAccountsCode("BL");
        awardAccount.setAccountNumber(accountNumber);
        awardAccount.setPrincipalId("5334003983");
        awardAccount.setActive(true);
        return awardAccount;
    }
}

