/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.batch.CfdaBatchStep;
import org.kuali.kfs.module.cg.businessobject.CFDA;
import org.kuali.kfs.module.cg.service.impl.CfdaServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CfdaServiceImplTest {
    private List<CFDA> testCfdas = new ArrayList<CFDA>();
    private CFDA cfda1 = new CFDA("10.030", "Test Title 1", "AUTOMATIC", true);
    private CFDA cfda2 = new CFDA("10.031", "Manual Test Title 2", "MANUAL", true);
    private CFDA cfda3 = new CFDA("10.040", "Test Title 3", "AUTOMATIC", false);
    private CfdaServiceImpl cut;
    @Mock
    private ParameterService parameterServiceMock;
    @Mock
    private DataDictionaryService dataDictionaryServiceMock;
    @Mock
    private BusinessObjectService businessObjectServiceMock;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new CfdaServiceImpl();
        this.cut.setParameterService(this.parameterServiceMock);
        this.cut.setDataDictionaryService(this.dataDictionaryServiceMock);
        Mockito.when((Object)this.dataDictionaryServiceMock.getAttributeMaxLength(CFDA.class, "cfdaProgramTitleName")).thenReturn((Object)25);
        this.cut.setBusinessObjectService(this.businessObjectServiceMock);
        this.testCfdas.add(this.cfda1);
        this.testCfdas.add(this.cfda2);
        this.testCfdas.add(this.cfda3);
        Mockito.when((Object)this.businessObjectServiceMock.findAll(CFDA.class)).thenReturn(this.testCfdas);
    }

    @Test
    public void getGovCodes() {
        String testFile = this.getClass().getResource(".." + File.separator + ".." + File.separator + "fixture" + File.separator + "AssistanceListings_DataGov_PUBLIC_CURRENT_small.csv").toString();
        Mockito.when((Object)this.parameterServiceMock.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL")).thenReturn((Object)testFile);
        Map map = this.cut.getGovCodes();
        Assert.assertEquals((long)8L, (long)map.size());
        CFDA cfda = (CFDA)map.get("10.053");
        Assert.assertEquals((Object)"Dairy Indemnity Program", (Object)cfda.getCfdaProgramTitleName());
        Assert.assertEquals((Object)"AUTOMATIC", (Object)cfda.getCfdaMaintenanceTypeId());
        Assert.assertTrue((boolean)cfda.isActive());
        CFDA cfdaTrimmed = (CFDA)map.get("10.051");
        Assert.assertEquals((Object)"Commodity Loans and Loan ", (Object)cfdaTrimmed.getCfdaProgramTitleName());
    }

    @Test
    public void getGovCodes_BAD_FILE() {
        String testFile = this.getClass().getResource(".." + File.separator + ".." + File.separator + "fixture" + File.separator + "AssistanceListings_DataGov_PUBLIC_CURRENT_bad.csv").toString();
        Mockito.when((Object)this.parameterServiceMock.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL")).thenReturn((Object)testFile);
        this.expectedException.expect(RuntimeException.class);
        this.cut.getGovCodes();
    }

    @Test
    public void getGovCodes_NO_RESULT() {
        String testFile = "does_no_exist.csv";
        Mockito.when((Object)this.parameterServiceMock.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL")).thenReturn((Object)"does_no_exist.csv");
        this.expectedException.expect(RuntimeException.class);
        this.cut.getGovCodes();
    }

    @Test
    public void getKfsCodes() {
        Map map = this.cut.getKfsCodes();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)this.cfdaEquals(this.cfda1, (CFDA)map.get("10.030")));
        Assert.assertTrue((boolean)this.cfdaEquals(this.cfda2, (CFDA)map.get("10.031")));
        Assert.assertTrue((boolean)this.cfdaEquals(this.cfda3, (CFDA)map.get("10.040")));
    }

    private boolean cfdaEquals(CFDA cfda1, CFDA cfda2) {
        return cfda1.getCfdaNumber().equalsIgnoreCase(cfda2.getCfdaNumber()) && cfda1.getCfdaProgramTitleName().equalsIgnoreCase(cfda2.getCfdaProgramTitleName()) && cfda1.getCfdaMaintenanceTypeId().equalsIgnoreCase(cfda2.getCfdaMaintenanceTypeId()) && cfda1.isActive() == cfda2.isActive();
    }
}

