/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;

public class ContractsAndGrantsModuleBillingServiceImpl
implements ContractsAndGrantsModuleBillingService {
    protected BusinessObjectService businessObjectService;
    protected LookupService LookupService;

    public List<? extends ContractsAndGrantsAward> lookupAwards(Map<String, String> fieldValues, boolean unbounded) {
        String date;
        String value = fieldValues.remove("accountNumber");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            fieldValues.put("awardAccounts.account.accountNumber", value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = fieldValues.remove("awardBillingFrequency")))) {
            fieldValues.put("billingFrequencyCode", value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = fieldValues.remove("awardTotal")))) {
            fieldValues.put("awardTotalAmount", value);
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate")) && StringUtils.isNotEmpty((CharSequence)fieldValues.get("awardBeginningDate"))) {
            date = fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate") + ".." + fieldValues.remove("awardBeginningDate");
            fieldValues.put("awardBeginningDate", date);
        } else if (StringUtils.isEmpty((CharSequence)fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate")) && StringUtils.isNotEmpty((CharSequence)fieldValues.get("awardBeginningDate"))) {
            date = "<=" + fieldValues.remove("awardBeginningDate");
            fieldValues.put("awardBeginningDate", date);
        } else if (StringUtils.isEmpty((CharSequence)fieldValues.get("awardBeginningDate")) && StringUtils.isNotEmpty((CharSequence)fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate"))) {
            date = ">=" + fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
            fieldValues.put("awardBeginningDate", date);
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate")) && StringUtils.isNotEmpty((CharSequence)fieldValues.get("awardEndingDate"))) {
            date = fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate") + ".." + fieldValues.remove("awardEndingDate");
            fieldValues.put("awardEndingDate", date);
        } else if (StringUtils.isEmpty((CharSequence)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate")) && StringUtils.isNotEmpty((CharSequence)fieldValues.get("awardEndingDate"))) {
            date = "<=" + fieldValues.remove("awardEndingDate");
            fieldValues.put("awardEndingDate", date);
        } else if (StringUtils.isEmpty((CharSequence)fieldValues.get("awardEndingDate")) && StringUtils.isNotEmpty((CharSequence)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate"))) {
            date = ">=" + fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate");
            fieldValues.put("awardEndingDate", date);
        }
        return (List)this.LookupService.findCollectionBySearchHelper(Award.class, fieldValues, unbounded);
    }

    public ContractsAndGrantsBillingAward updateAwardIfNecessary(String proposalNumber, ContractsAndGrantsBillingAward currentAward) {
        ContractsAndGrantsBillingAward award = currentAward;
        if (ObjectUtils.isNull((Object)proposalNumber)) {
            award = null;
        } else if (ObjectUtils.isNull((Object)currentAward) || !StringUtils.equals((CharSequence)currentAward.getProposalNumber(), (CharSequence)proposalNumber)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("proposalNumber", proposalNumber);
            award = (ContractsAndGrantsBillingAward)this.businessObjectService.findByPrimaryKey(Award.class, primaryKeys);
        }
        return award;
    }

    public ContractsAndGrantsBillingAwardAccount updateAwardAccountIfNecessary(String proposalNumber, String chartOfAccountsCode, String accountNumber, ContractsAndGrantsBillingAwardAccount currentAwardAccount) {
        ContractsAndGrantsBillingAwardAccount awardAccount = currentAwardAccount;
        if (StringUtils.isBlank((CharSequence)proposalNumber) || StringUtils.isBlank((CharSequence)chartOfAccountsCode) || StringUtils.isBlank((CharSequence)accountNumber)) {
            awardAccount = null;
        } else if (this.awardAccountNeedsUpdating(proposalNumber, chartOfAccountsCode, accountNumber, currentAwardAccount)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("proposalNumber", proposalNumber);
            primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
            primaryKeys.put("accountNumber", accountNumber);
            awardAccount = (ContractsAndGrantsBillingAwardAccount)this.businessObjectService.findByPrimaryKey(AwardAccount.class, primaryKeys);
        }
        return awardAccount;
    }

    private boolean awardAccountNeedsUpdating(String proposalNumber, String chartOfAccountsCode, String accountNumber, ContractsAndGrantsBillingAwardAccount currentAwardAccount) {
        if (ObjectUtils.isNull((Object)currentAwardAccount)) {
            return true;
        }
        return !StringUtils.equals((CharSequence)proposalNumber, (CharSequence)currentAwardAccount.getProposalNumber()) || !StringUtils.equals((CharSequence)chartOfAccountsCode, (CharSequence)currentAwardAccount.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)accountNumber, (CharSequence)currentAwardAccount.getAccountNumber());
    }

    public void setLastBilledDateToAwardAccount(Map<String, Object> criteria, boolean invoiceReversal, Date lastBilledDate) {
        AwardAccount awardAccount = (AwardAccount)this.getBusinessObjectService().findByPrimaryKey(AwardAccount.class, criteria);
        if (invoiceReversal) {
            awardAccount.setCurrentLastBilledDate(awardAccount.getPreviousLastBilledDate());
            awardAccount.setPreviousLastBilledDate(null);
        } else {
            awardAccount.setPreviousLastBilledDate(awardAccount.getCurrentLastBilledDate());
            awardAccount.setCurrentLastBilledDate(lastBilledDate);
        }
        this.getBusinessObjectService().save((PersistableBusinessObject)awardAccount);
    }

    public void setLastBilledDateToAward(String proposalNumber, Date lastBilledDate) {
    }

    public void setFinalBilledToAwardAccount(Map<String, Object> criteria, boolean finalBilled) {
        AwardAccount awardAccount = (AwardAccount)this.getBusinessObjectService().findByPrimaryKey(AwardAccount.class, criteria);
        awardAccount.setFinalBilledIndicator(finalBilled);
        this.getBusinessObjectService().save((PersistableBusinessObject)awardAccount);
    }

    public void setFinalBilledAndLastBilledDateToAwardAccount(Map<String, Object> criteria, boolean finalBilled, boolean invoiceReversal, Date lastBilledDate) {
        AwardAccount awardAccount = (AwardAccount)this.getBusinessObjectService().findByPrimaryKey(AwardAccount.class, criteria);
        if (invoiceReversal) {
            awardAccount.setCurrentLastBilledDate(awardAccount.getPreviousLastBilledDate());
            awardAccount.setPreviousLastBilledDate(null);
        } else {
            awardAccount.setPreviousLastBilledDate(awardAccount.getCurrentLastBilledDate());
            awardAccount.setCurrentLastBilledDate(lastBilledDate);
        }
        awardAccount.setFinalBilledIndicator(finalBilled);
        this.getBusinessObjectService().save((PersistableBusinessObject)awardAccount);
    }

    public Map<String, Object> getLetterOfCreditAwardCriteria(String fundGroupCode, String fundCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        if (ObjectUtils.isNotNull((Object)fundGroupCode)) {
            criteria.put("letterOfCreditFund.letterOfCreditFundGroupCode", fundGroupCode);
        }
        if (ObjectUtils.isNotNull((Object)fundCode)) {
            criteria.put("letterOfCreditFund.letterOfCreditFundCode", fundCode);
        }
        return criteria;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public LookupService getLookupService() {
        return this.LookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.LookupService = lookupService;
    }
}

