/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.document.ContractsGrantsBillingMaintainable;
import org.kuali.kfs.module.cg.service.ContractsAndGrantsBillingService;
import org.kuali.kfs.sys.context.SpringContext;

public class AgencyMaintainableImpl
extends ContractsGrantsBillingMaintainable {
    private static final String CREATED_BY_AGENCY_DOC = "message.ar.createdByAgencyDocument";
    private static volatile AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;

    public Agency getAgency() {
        return (Agency)this.getBusinessObject();
    }

    public void doRouteStatusChange(DocumentHeader header) {
        super.doRouteStatusChange(header);
        if (AgencyMaintainableImpl.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            WorkflowDocument workflowDoc = header.getWorkflowDocument();
            Agency agency = this.getAgency();
            String description = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(CREATED_BY_AGENCY_DOC);
            if (workflowDoc.isProcessed()) {
                try {
                    if (this.businessObject != null) {
                        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)agency);
                        for (AgencyAddress agencyAddress : agency.getAgencyAddresses()) {
                            agencyAddress.setAgency(agency);
                            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)agencyAddress);
                        }
                        if ("C".equalsIgnoreCase(agency.getCustomerCreationOptionCode())) {
                            String customerNumber = ((AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class)).createAndSaveCustomer(description, (ContractsAndGrantsBillingAgency)agency);
                            agency.setCustomerCreationOptionCode("E");
                            agency.setCustomerNumber(customerNumber);
                        } else if ("N".equalsIgnoreCase(agency.getCustomerCreationOptionCode())) {
                            agency.setCustomerCreationOptionCode("N");
                            agency.setCustomerNumber(null);
                            agency.setCustomer(null);
                            agency.setCustomerTypeCode(null);
                        }
                        HashMap<String, String> criteria = new HashMap<String, String>();
                        criteria.put("agencyNumber", agency.getAgencyNumber());
                        List awards = (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(Award.class, criteria);
                        for (Award award : awards) {
                            award.setDunningCampaign(agency.getDunningCampaign());
                            if (ObjectUtils.isNotNull((Object)agency.getCustomer()) && ObjectUtils.isNotNull((Object)agency.getCustomer().isStopWorkIndicator())) {
                                award.setStopWorkIndicator(agency.getCustomer().isStopWorkIndicator());
                            }
                            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)award);
                        }
                    }
                }
                catch (WorkflowException ex) {
                    throw new RuntimeException("Error creating Customer Document from Agency document.", ex);
                }
            }
        }
    }

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        Agency agency = (Agency)document.getNewMaintainableObject().getBusinessObject();
        for (Section section : sections) {
            String sectionId = section.getSectionId();
            if (!sectionId.equalsIgnoreCase("customer")) continue;
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (StringUtils.isNotEmpty((CharSequence)agency.getCustomerCreationOptionCode())) {
                        switch (agency.getCustomerCreationOptionCode()) {
                            case "E": {
                                if (field.getPropertyName().equals("customerNumber")) {
                                    field.setReadOnly(false);
                                    break;
                                }
                                if (!field.getPropertyName().equals("customerTypeCode")) break;
                                field.setReadOnly(true);
                                if (ObjectUtils.isNotNull((Object)agency.getCustomer())) {
                                    agency.setCustomerTypeCode(agency.getCustomer().getCustomerTypeCode());
                                    break;
                                }
                                agency.setCustomerTypeCode(null);
                                break;
                            }
                            case "C": {
                                if (field.getPropertyName().equals("customerNumber")) {
                                    agency.setCustomerNumber(null);
                                    field.setReadOnly(true);
                                    break;
                                }
                                if (!field.getPropertyName().equals("customerTypeCode")) break;
                                field.setReadOnly(false);
                                break;
                            }
                            case "N": {
                                if (field.getPropertyName().equals("customerNumber")) {
                                    agency.setCustomerNumber(null);
                                    field.setReadOnly(true);
                                    break;
                                }
                                if (!field.getPropertyName().equals("customerTypeCode")) break;
                                field.setReadOnly(true);
                                agency.setCustomerTypeCode(null);
                                break;
                            }
                        }
                        continue;
                    }
                    if (field.getPropertyName().equals("customerNumber")) {
                        agency.setCustomerNumber(null);
                        field.setReadOnly(true);
                        continue;
                    }
                    if (!field.getPropertyName().equals("customerTypeCode")) continue;
                    agency.setCustomerTypeCode(null);
                    field.setReadOnly(true);
                }
            }
        }
        return sections;
    }

    @Override
    protected Collection<?> getSectionIdsToIgnore() {
        if (!AgencyMaintainableImpl.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            return ((ContractsAndGrantsBillingService)SpringContext.getBean(ContractsAndGrantsBillingService.class)).getAgencyContractsGrantsBillingSectionIds();
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        Agency agency = this.getAgency();
        String customerNumber = (String)fieldValues.get("document.newMaintainableObject..customerNumber");
        if (ObjectUtils.isNotNull((Object)customerNumber)) {
            AccountsReceivableCustomer customer = ((AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class)).findCustomer(customerNumber);
            agency.setCustomerTypeCode(customer.getCustomerTypeCode());
        }
        super.refresh(refreshCaller, fieldValues, document);
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        Agency agency = this.getAgency();
        String parameterDunningCampaignCode = AgencyMaintainableImpl.getAccountsReceivableModuleBillingService().getDefaultDunningCampaignCode();
        if (StringUtils.isNotBlank((CharSequence)parameterDunningCampaignCode)) {
            agency.setDunningCampaign(parameterDunningCampaignCode);
        }
    }

    public static AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        if (accountsReceivableModuleBillingService == null) {
            accountsReceivableModuleBillingService = (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
        }
        return accountsReceivableModuleBillingService;
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        Agency agency = (Agency)this.getBusinessObject();
        List<AgencyAddress> agencyAddresses = agency.getAgencyAddresses();
        for (AgencyAddress agencyAddress : agencyAddresses) {
            agencyAddress.setAgencyAddressIdentifier(null);
        }
    }
}

