/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.service.AgencyService;
import org.kuali.kfs.module.cg.service.CfdaService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class ContractsAndGrantsModuleServiceImpl
implements ContractsAndGrantsModuleService {
    protected ParameterService parameterService;
    protected AgencyService agencyService;
    protected CfdaService cfdaService;
    protected BusinessObjectService businessObjectService;

    public Person getProjectDirectorForAccount(String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> awardAccountMap = new HashMap<String, String>();
        awardAccountMap.put("chartOfAccountsCode", chartOfAccountsCode);
        awardAccountMap.put("accountNumber", accountNumber);
        Collection proposals = this.getBusinessObjectService().findMatchingOrderBy(AwardAccount.class, awardAccountMap, "proposalNumber", false);
        if (proposals != null && !proposals.isEmpty()) {
            AwardAccount proposalWithMaxProposalNumber = (AwardAccount)proposals.iterator().next();
            return proposalWithMaxProposalNumber.getProjectDirector();
        }
        return null;
    }

    public Person getProjectDirectorForAccount(Account account) {
        if (ObjectUtils.isNotNull((Object)account)) {
            account.refreshNonUpdateableReferences();
            String chartOfAccountsCode = account.getChartOfAccountsCode();
            String accountNumber = account.getAccountNumber();
            return this.getProjectDirectorForAccount(chartOfAccountsCode, accountNumber);
        }
        return null;
    }

    public boolean isAwardedByFederalAgency(String chartOfAccountsCode, String accountNumber, Collection<String> federalAgencyTypeCodes) {
        AwardAccount primaryAward = this.getPrimaryAwardAccount(chartOfAccountsCode, accountNumber);
        if (primaryAward == null) {
            return false;
        }
        String agencyTypeCode = primaryAward.getAward().getAgency().getAgencyTypeCode();
        return federalAgencyTypeCodes.contains(agencyTypeCode) || primaryAward.getAward().getFederalPassThroughIndicator();
    }

    protected AwardAccount getPrimaryAwardAccount(String chartOfAccountsCode, String accountNumber) {
        AwardAccount primaryAwardAccount = null;
        long highestProposalNumber = 0L;
        HashMap<String, String> accountKeyValues = new HashMap<String, String>();
        accountKeyValues.put("chartOfAccountsCode", chartOfAccountsCode);
        accountKeyValues.put("accountNumber", accountNumber);
        for (Object awardAccountAsObject : this.getBusinessObjectService().findMatching(AwardAccount.class, accountKeyValues)) {
            AwardAccount awardAccount = (AwardAccount)awardAccountAsObject;
            Long proposalNumber = Long.parseLong(awardAccount.getProposalNumber());
            if (proposalNumber < highestProposalNumber) continue;
            highestProposalNumber = proposalNumber;
            primaryAwardAccount = awardAccount;
        }
        return primaryAwardAccount;
    }

    public List<Integer> getAllAccountReponsiblityIds() {
        int maxResponsibilityId = this.getMaxiumAccountResponsibilityId();
        ArrayList<Integer> contractsAndGrantsResponsiblityIds = new ArrayList<Integer>();
        for (int id = 1; id <= maxResponsibilityId; ++id) {
            contractsAndGrantsResponsiblityIds.add(id);
        }
        return contractsAndGrantsResponsiblityIds;
    }

    public boolean hasValidAccountReponsiblityIdIfNotNull(Account account) {
        Integer accountResponsibilityId = account.getContractsAndGrantsAccountResponsibilityId();
        if (accountResponsibilityId == null) {
            return true;
        }
        return accountResponsibilityId >= 1 && accountResponsibilityId <= this.getMaxiumAccountResponsibilityId();
    }

    protected int getMaxiumAccountResponsibilityId() {
        String maxResponsibilityId = this.getParameterService().getParameterValueAsString(KfsParameterConstants.CHART_ALL.class, "MAXIMUM_ACCOUNT_RESPONSIBILITY_ID");
        return Integer.parseInt(maxResponsibilityId);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public AgencyService getAgencyService() {
        return this.agencyService;
    }

    public CfdaService getCfdaService() {
        return this.cfdaService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public List<String> getParentUnits(String unitNumber) {
        return null;
    }

    public String getProposalNumberForAccountAndProjectDirector(String chartOfAccountsCode, String accountNumber, String projectDirectorId) {
        AwardAccount proposalWithMaxProposalNumber;
        String proposalNumber = null;
        HashMap<String, String> awardAccountMap = new HashMap<String, String>();
        awardAccountMap.put("chartOfAccountsCode", chartOfAccountsCode);
        awardAccountMap.put("accountNumber", accountNumber);
        Collection proposals = this.getBusinessObjectService().findMatchingOrderBy(AwardAccount.class, awardAccountMap, "proposalNumber", false);
        if (proposals != null && !proposals.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)(proposalWithMaxProposalNumber = (AwardAccount)proposals.iterator().next()).getProjectDirector().getPrincipalId(), (CharSequence)projectDirectorId)) {
            proposalNumber = proposalWithMaxProposalNumber.getProposalNumber();
        }
        return proposalNumber;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setAgencyService(AgencyService agencyService) {
        this.agencyService = agencyService;
    }

    public void setCfdaService(CfdaService cfdaService) {
        this.cfdaService = cfdaService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

