/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.rule.event.PromptBeforeValidationEvent;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.document.validation.impl.AwardPreRules;
import org.kuali.kfs.module.cg.fixture.AwardFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class AwardPreRulesTest {
    private static final String WARNING_AWARD_ENTRY_BEFORE_START_DATE = "warning.cg.award.entryDateBeforeStartDate={0} is before {1}. Do you wish to continue?";
    private static final String WARNING_AWARD_SUBCONTRACTOR_TOTAL_GREATER_THAN_AWARD_TOTAL = "{0} total amount is greater than total {1} amount.  Do you want to continue?";
    private static final String WARNING_CG_AWARD_TOTAL_AWARD_AMOUNT_LESS_THAN_SCHEDULED_AMOUNT = "The Total Award Amount is less than the associated {0} amounts.  Do you want to continue?";
    private static final String BEGINNING_DATE_LABEL = "Beginning Date";
    private static final String ENTRY_DATE_LABEL = "Entry Date";
    private static final String AWARD_SUBCONTRACTORS_LABEL = "Award Subcontractors";
    private static final String TOTAL_AMOUNT_LABEL = "Total Amount";
    private AwardPreRules cutSpy;
    private Award award;
    @Mock(stubOnly=true)
    private AccountsReceivableModuleBillingService accountsReceivableModuleBillingSvcMock;
    @Mock(stubOnly=true)
    private ConfigurationService configurationSvcMock;
    @Mock(stubOnly=true)
    private DataDictionaryService dataDictionarySvcMock;
    @Mock(stubOnly=true)
    private Maintainable newMaintainableMock;
    @Mock(stubOnly=true)
    private MaintenanceDocument awardMaintenanceDocumentMock;
    private PromptBeforeValidationEvent event;
    private String milestoneQuestionText;
    private String billQuestionText;

    AwardPreRulesTest() {
    }

    @BeforeEach
    void setUp(@Mock(stubOnly=true) HttpServletRequest httpServletRequestMock) {
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(DataDictionaryService.class)).thenReturn((Object)this.dataDictionarySvcMock);
            this.cutSpy = (AwardPreRules)Mockito.spy(AwardPreRules.class);
        }
        this.award = AwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        Mockito.when((Object)this.newMaintainableMock.getBusinessObject()).thenReturn((Object)this.award);
        Mockito.when((Object)this.awardMaintenanceDocumentMock.getNewMaintainableObject()).thenReturn((Object)this.newMaintainableMock);
        this.event = new PromptBeforeValidationEvent("description", "errorPathPrefix", (Document)this.awardMaintenanceDocumentMock);
        this.setupEventToAvoidNPE(httpServletRequestMock, this.event);
        this.milestoneQuestionText = MessageFormat.format(WARNING_CG_AWARD_TOTAL_AWARD_AMOUNT_LESS_THAN_SCHEDULED_AMOUNT, "Milestone");
        this.billQuestionText = MessageFormat.format(WARNING_CG_AWARD_TOTAL_AWARD_AMOUNT_LESS_THAN_SCHEDULED_AMOUNT, "Predetermined Billing");
    }

    private void setupEventToAvoidNPE(HttpServletRequest httpServletRequestMock, PromptBeforeValidationEvent event) {
        Mockito.when((Object)httpServletRequestMock.getParameter("questionIndex")).thenReturn((Object)"AwardAmountLessThanScheduleAmountQuestion");
        ((AwardPreRules)Mockito.doReturn((Object)true).when((Object)this.cutSpy)).doPrompts((Document)this.awardMaintenanceDocumentMock);
        this.cutSpy.processPrompts(null, httpServletRequestMock, event);
    }

    @Test
    void doCustomPreRules_noWarnings_CGB_Off() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_noWarnings_CGB_On() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_EntryDateBeforeBeginDate() {
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.cg.award.entryDateBeforeStartDate")).thenReturn((Object)WARNING_AWARD_ENTRY_BEFORE_START_DATE);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(Award.class, "awardEntryDate")).thenReturn((Object)ENTRY_DATE_LABEL);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(Award.class, "awardBeginningDate")).thenReturn((Object)BEGINNING_DATE_LABEL);
        Date today = Date.valueOf(LocalDate.now());
        Date yesterday = Date.valueOf(LocalDate.now().minusDays(1L));
        this.award.setAwardEntryDate(yesterday);
        this.award.setAwardBeginningDate(today);
        String questionText = MessageFormat.format(WARNING_AWARD_ENTRY_BEFORE_START_DATE, ENTRY_DATE_LABEL, BEGINNING_DATE_LABEL);
        ((AwardPreRules)Mockito.doReturn((Object)false).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("entryDateBeforeStartDateQuestion", questionText);
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertEquals((Object)"basic", (Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.times((int)1))).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_EntryDateAfterBeginDate() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Date today = Date.valueOf(LocalDate.now());
        Date yesterday = Date.valueOf(LocalDate.now().minusDays(1L));
        this.award.setAwardEntryDate(today);
        this.award.setAwardBeginningDate(yesterday);
        String questionText = MessageFormat.format(WARNING_AWARD_ENTRY_BEFORE_START_DATE, ENTRY_DATE_LABEL, BEGINNING_DATE_LABEL);
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("entryDateBeforeStartDateQuestion", questionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_SubcontractorTotalGreaterThanAwardTotal() {
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.cg.award.subcontractorAmountGreaterThanAwardAmount")).thenReturn((Object)WARNING_AWARD_SUBCONTRACTOR_TOTAL_GREATER_THAN_AWARD_TOTAL);
        Mockito.when((Object)this.dataDictionarySvcMock.getCollectionLabel(Award.class, "awardSubcontractors")).thenReturn((Object)AWARD_SUBCONTRACTORS_LABEL);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(Award.class, "awardTotalAmount")).thenReturn((Object)TOTAL_AMOUNT_LABEL);
        this.award.setAwardDirectCostAmount(new KualiDecimal(10000.0));
        this.award.setAwardSubcontractors(AwardPreRulesTest.setupAwardSubcontractors(new KualiDecimal(20000.0)));
        String questionText = MessageFormat.format(WARNING_AWARD_SUBCONTRACTOR_TOTAL_GREATER_THAN_AWARD_TOTAL, AWARD_SUBCONTRACTORS_LABEL, TOTAL_AMOUNT_LABEL);
        ((AwardPreRules)Mockito.doReturn((Object)false).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("subcontractorTotalGreaterThanAwardTotalQuestion", questionText);
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertEquals((Object)"basic", (Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.times((int)1))).abortRulesCheck();
    }

    private static List<AwardSubcontractor> setupAwardSubcontractors(KualiDecimal subcontractorAmount) {
        ArrayList<AwardSubcontractor> awardSubcontractors = new ArrayList<AwardSubcontractor>();
        AwardSubcontractor subcontractor = new AwardSubcontractor();
        subcontractor.setSubcontractorAmount(subcontractorAmount);
        awardSubcontractors.add(subcontractor);
        return awardSubcontractors;
    }

    @Test
    void doCustomPreRules_SubcontractorTotalLessThanAwardTotal() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.award.setAwardDirectCostAmount(new KualiDecimal(20000.0));
        this.award.setAwardSubcontractors(AwardPreRulesTest.setupAwardSubcontractors(new KualiDecimal(10000.0)));
        String questionText = MessageFormat.format(WARNING_AWARD_SUBCONTRACTOR_TOTAL_GREATER_THAN_AWARD_TOTAL, AWARD_SUBCONTRACTORS_LABEL, TOTAL_AMOUNT_LABEL);
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("subcontractorTotalGreaterThanAwardTotalQuestion", questionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_MilestoneSchedule_AmountLessThanMilestonesTotal_CGB_On() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.cg.award.totalAwardAmountLessThanScheduleAmount")).thenReturn((Object)WARNING_CG_AWARD_TOTAL_AWARD_AMOUNT_LESS_THAN_SCHEDULED_AMOUNT);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award.setBillingFrequencyCode("MILE");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmount(this.award.getProposalNumber())).thenReturn((Object)new KualiDecimal(2500.0));
        ((AwardPreRules)Mockito.doReturn((Object)false).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.milestoneQuestionText);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        }
        Assertions.assertEquals((Object)"basic", (Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.times((int)1))).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_MilestoneSchedule_AmountLessThanMilestonesTotal_CGB_Off() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.milestoneQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_MilestoneSchedule_AmountEqualToMilestonesTotal_CGB_On() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award.setBillingFrequencyCode("MILE");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmount(this.award.getProposalNumber())).thenReturn((Object)new KualiDecimal(1500.0));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        }
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.milestoneQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_MilestoneSchedule_AmountEqualToMilestonesTotal_CGB_Off() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.milestoneQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_MilestoneSchedule_AmountGreaterThanMilestonesTotal_CGB_On() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award.setBillingFrequencyCode("MILE");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmount(this.award.getProposalNumber())).thenReturn((Object)new KualiDecimal(500.0));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        }
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.milestoneQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_MilestoneSchedule_AmountGreaterThanMilestonesTotal_CGB_Off() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.award.setBillingFrequencyCode("MILE");
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.milestoneQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_PredeterminedBillingSchedule_AmountLessThanBillsTotal_CGB_On() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.cg.award.totalAwardAmountLessThanScheduleAmount")).thenReturn((Object)WARNING_CG_AWARD_TOTAL_AWARD_AMOUNT_LESS_THAN_SCHEDULED_AMOUNT);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award.setBillingFrequencyCode("PDBS");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getBillsTotalAmount(this.award.getProposalNumber())).thenReturn((Object)new KualiDecimal(2500.0));
        ((AwardPreRules)Mockito.doReturn((Object)false).when((Object)this.cutSpy)).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.billQuestionText);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        }
        Assertions.assertEquals((Object)"basic", (Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.times((int)1))).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_PredeterminedBillingSchedule_AmountLessThanBillsTotal_CGB_Off() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.award.setBillingFrequencyCode("PDBS");
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.billQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_PredeterminedBillingSchedule_AmountEqualToBillsTotal_CGB_On(@Mock(stubOnly=true) AccountService accountSvcMock) {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award.setBillingFrequencyCode("PDBS");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getBillsTotalAmount(this.award.getProposalNumber())).thenReturn((Object)new KualiDecimal(1500.0));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)accountSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(DataDictionaryService.class)).thenReturn((Object)this.dataDictionarySvcMock);
            this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        }
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.billQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_PredeterminedBillingSchedule_AmountEqualToBillsTotal_CGB_Off() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.award.setBillingFrequencyCode("PDBS");
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.billQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_PredeterminedBillingSchedule_AmountGreaterThanBillsTotal_CGB_On(@Mock(stubOnly=true) AccountService accountSvcMock) {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)true);
        this.award.setBillingFrequencyCode("PDBS");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getBillsTotalAmount(this.award.getProposalNumber())).thenReturn((Object)new KualiDecimal(500.0));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountsReceivableModuleBillingService.class)).thenReturn((Object)this.accountsReceivableModuleBillingSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)accountSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn((Object)this.configurationSvcMock);
            springContextMockedStatic.when(() -> SpringContext.getBean(DataDictionaryService.class)).thenReturn((Object)this.dataDictionarySvcMock);
            this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        }
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.billQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }

    @Test
    void doCustomPreRules_PredeterminedBillingSchedule_AmountGreaterThanBillsTotal_CGB_Off() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.isContractsGrantsBillingEnhancementActive()).thenReturn((Object)false);
        this.award.setBillingFrequencyCode("PDBS");
        this.cutSpy.doCustomPreRules(this.awardMaintenanceDocumentMock);
        Assertions.assertNull((Object)this.event.getActionForwardName());
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).askOrAnalyzeYesNoQuestion("AwardAmountLessThanScheduleAmountQuestion", this.billQuestionText);
        ((AwardPreRules)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.never())).abortRulesCheck();
    }
}

