/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.batch.CfdaBatchStep;
import org.kuali.kfs.module.cg.businessobject.CFDA;
import org.kuali.kfs.module.cg.businessobject.CfdaUpdateResults;
import org.kuali.kfs.module.cg.service.CfdaService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

public class CfdaServiceImpl
implements CfdaService {
    private static final CSVParser CSV_PARSER = new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').withEscapeChar('\u0000').build();
    private static final Logger LOG = LogManager.getLogger();
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private DataDictionaryService dataDictionaryService;

    @Override
    @Transactional
    public CfdaUpdateResults update() {
        CfdaUpdateResults results = new CfdaUpdateResults();
        Map<String, CFDA> govMap = this.getGovCodes();
        Map<String, CFDA> kfsMap = this.getKfsCodes();
        results.setNumberOfRecordsInKfsDatabase(kfsMap.keySet().size());
        results.setNumberOfRecordsRetrievedFromWebSite(govMap.keySet().size());
        for (String key : kfsMap.keySet()) {
            CFDA cfdaKfs = kfsMap.get(key);
            CFDA cfdaGov = govMap.get(key);
            if (cfdaKfs.getCfdaMaintenanceTypeId().startsWith("M")) {
                results.setNumberOfRecordsNotUpdatedBecauseManual(1 + results.getNumberOfRecordsNotUpdatedBecauseManual());
            } else if (cfdaKfs.getCfdaMaintenanceTypeId().startsWith("A")) {
                if (cfdaGov == null) {
                    if (cfdaKfs.isActive()) {
                        cfdaKfs.setActive(false);
                        this.businessObjectService.save((PersistableBusinessObject)cfdaKfs);
                        results.setNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite(results.getNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite() + 1);
                    } else {
                        results.setNumberOfRecrodsNotUpdatedForHistoricalPurposes(results.getNumberOfRecrodsNotUpdatedForHistoricalPurposes() + 1);
                    }
                } else {
                    if (cfdaKfs.isActive()) {
                        results.setNumberOfRecordsUpdatedBecauseAutomatic(results.getNumberOfRecordsUpdatedBecauseAutomatic() + 1);
                    } else {
                        cfdaKfs.setActive(true);
                        results.setNumberOfRecordsReActivated(results.getNumberOfRecordsReActivated() + 1);
                    }
                    cfdaKfs.setCfdaProgramTitleName(cfdaGov.getCfdaProgramTitleName());
                    this.businessObjectService.save((PersistableBusinessObject)cfdaKfs);
                }
            }
            govMap.remove(key);
        }
        for (String key : govMap.keySet()) {
            CFDA cfdaGov = govMap.get(key);
            this.businessObjectService.save((PersistableBusinessObject)cfdaGov);
            results.setNumberOfRecordsNewlyAddedFromWebSite(results.getNumberOfRecordsNewlyAddedFromWebSite() + 1);
        }
        return results;
    }

    @Override
    public CFDA getByPrimaryId(String cfdaNumber) {
        if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
            return null;
        }
        return (CFDA)this.businessObjectService.findBySinglePrimaryKey(CFDA.class, (Object)cfdaNumber.trim());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    Map<String, CFDA> getGovCodes() {
        String govURL = this.parameterService.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL");
        LOG.info("Getting government file from URL {} for update", (Object)govURL);
        Resource csvFile = this.getCfdaResource(govURL);
        if (csvFile != null && csvFile.exists() && csvFile.isReadable()) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(csvFile.getInputStream(), StandardCharsets.UTF_8);){
                Map<String, CFDA> map;
                block14: {
                    CSVReader reader = new CSVReaderBuilder((Reader)inputStreamReader).withCSVParser((ICSVParser)CSV_PARSER).withSkipLines(1).build();
                    try {
                        List records = reader.readAll();
                        map = records.stream().map(record -> new CFDA(record[1], this.trimProgramTitleName(record[0]), "AUTOMATIC", true)).collect(Collectors.toMap(CFDA::getCfdaNumber, value -> value));
                        if (reader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                return map;
            }
            catch (CsvException | IOException e) {
                throw new RuntimeException("The file could not be retrieved from " + govURL, e);
            }
        }
        throw new RuntimeException("The file could not be retrieved from " + govURL);
    }

    Resource getCfdaResource(String govURL) {
        return new DefaultResourceLoader(this.getClass().getClassLoader()).getResource(govURL);
    }

    Map<String, CFDA> getKfsCodes() {
        Collection kfsCodes = this.businessObjectService.findAll(CFDA.class);
        return kfsCodes.stream().collect(Collectors.toMap(CFDA::getCfdaNumber, value -> value));
    }

    private String trimProgramTitleName(String programTitleName) {
        return StringUtils.substring((String)programTitleName, (int)0, (int)this.dataDictionaryService.getAttributeMaxLength(CFDA.class, "cfdaProgramTitleName"));
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

