/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject.inquiry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableMilestoneSchedule;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.AccountsReceivablePredeterminedBillingSchedule;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.datadictionary.InquirySectionDefinition;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.inquiry.InquiryRestrictions;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.FieldBridge;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.kns.web.ui.SectionBridge;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.service.ContractsAndGrantsBillingService;
import org.kuali.kfs.sys.context.SpringContext;

public class AwardInquirableImpl
extends KualiInquirableImpl {
    private static final Logger LOG = LogManager.getLogger();

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if (StringUtils.equals((CharSequence)"milestoneSchedule.milestoneScheduleInquiryTitle", (CharSequence)attributeName)) {
            return this.buildInquiryUrl(businessObject, AccountsReceivableMilestoneSchedule.class);
        }
        if (StringUtils.equals((CharSequence)"predeterminedBillingSchedule.predeterminedBillingScheduleInquiryTitle", (CharSequence)attributeName)) {
            return this.buildInquiryUrl(businessObject, AccountsReceivablePredeterminedBillingSchedule.class);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

    private HtmlData.AnchorHtmlData buildInquiryUrl(BusinessObject businessObject, Class businessObjectClass) {
        HtmlData.AnchorHtmlData inquiryHref = new HtmlData.AnchorHtmlData("", "");
        String baseUrl = "lookup.do";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "search");
        parameters.put("mode", "lookup");
        parameters.put("businessObjectClassName", businessObjectClass.getName());
        parameters.put("proposalNumber", ObjectUtils.getPropertyValue((Object)businessObject, (String)"proposalNumber").toString());
        inquiryHref.setHref(UrlFactory.parameterizeUrl((String)baseUrl, parameters));
        return inquiryHref;
    }

    public List<Section> getSections(BusinessObject businessObject) {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (this.getBusinessObjectClass() == null) {
            LOG.error("Business object class not set in inquirable.");
            throw new RuntimeException("Business object class not set in inquirable.");
        }
        InquiryRestrictions inquiryRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getInquiryRestrictions(businessObject, GlobalVariables.getUserSession().getPerson());
        List inquirySections = this.getBusinessObjectDictionaryService().getInquirySections(this.getBusinessObjectClass());
        Collection<?> sectionIdsToIgnore = this.getSectionIdsToIgnore();
        for (InquirySectionDefinition inquirySection : inquirySections) {
            String sectionId = inquirySection.getId();
            if (inquiryRestrictions.isHiddenSectionId(sectionId) || sectionIdsToIgnore.contains(sectionId)) continue;
            Section section = SectionBridge.toSection((Inquirable)this, (InquirySectionDefinition)inquirySection, (BusinessObject)businessObject, (InquiryRestrictions)inquiryRestrictions);
            if (StringUtils.equals((CharSequence)sectionId, (CharSequence)"invoicingSection")) {
                for (Row row : section.getRows()) {
                    List updatedFields = row.getFields().stream().map(field -> this.determineScheduleInquiryField((Field)field, (Award)businessObject)).collect(Collectors.toList());
                    row.setFields(updatedFields);
                }
            }
            sections.add(section);
        }
        return sections;
    }

    private Field determineScheduleInquiryField(Field field, Award award) {
        if (field.getPropertyName().equalsIgnoreCase("scheduleInquiryTitle")) {
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                if (StringUtils.equals((CharSequence)award.getBillingFrequencyCode(), (CharSequence)"MILE") && ((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).hasMilestoneSchedule(award.getProposalNumber(), awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())) {
                    Field newField = FieldUtils.getPropertyField(Award.class, (String)"milestoneSchedule.milestoneScheduleInquiryTitle", (boolean)false);
                    FieldBridge.populateFieldFromBusinessObject((Field)newField, (BusinessObject)award);
                    return newField;
                }
                if (!StringUtils.equals((CharSequence)award.getBillingFrequencyCode(), (CharSequence)"PDBS") || !((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).hasPredeterminedBillingSchedule(award.getProposalNumber(), awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())) continue;
                Field newField = FieldUtils.getPropertyField(Award.class, (String)"predeterminedBillingSchedule.predeterminedBillingScheduleInquiryTitle", (boolean)false);
                FieldBridge.populateFieldFromBusinessObject((Field)newField, (BusinessObject)award);
                return newField;
            }
            return null;
        }
        return field;
    }

    private Collection<?> getSectionIdsToIgnore() {
        if (!((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).isContractsGrantsBillingEnhancementActive()) {
            return ((ContractsAndGrantsBillingService)SpringContext.getBean(ContractsAndGrantsBillingService.class)).getAwardContractsGrantsBillingSectionIds();
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }
}

