/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.cg.CGIntegrationConstants;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRuleUtil;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.springframework.util.AutoPopulatingList;

public class AwardRule
extends CGMaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    protected Award newAwardCopy;
    protected Award oldAwardCopy;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering AwardRule.processCustomSaveDocumentBusinessRules");
        this.processCustomRouteDocumentBusinessRules(document);
        LOG.info("Leaving AwardRule.processCustomSaveDocumentBusinessRules");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering AwardRule.processCustomRouteDocumentBusinessRules");
        boolean success = this.checkProposal();
        success &= this.checkEndAfterBegin(this.newAwardCopy.getAwardBeginningDate(), this.newAwardCopy.getAwardEndingDate(), "awardEndingDate");
        success &= this.checkPrimary(this.newAwardCopy.getAwardOrganizations(), AwardOrganization.class, "awardOrganizations", Award.class);
        success &= this.checkPrimary(this.newAwardCopy.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors", Award.class);
        success &= this.checkForDuplicateAccounts();
        success &= this.checkForDuplicateAwardProjectDirector();
        success &= this.checkForDuplicateAwardOrganization();
        success &= this.checkAccounts();
        success &= this.checkProjectDirectorsExist(this.newAwardCopy.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors");
        success &= this.checkFundManagersExist(this.newAwardCopy.getAwardFundManagers(), "awardFundManagers");
        success &= this.checkProjectDirectorsExist(this.newAwardCopy.getAwardAccounts(), AwardAccount.class, "awardAccounts");
        success &= this.checkProjectDirectorsStatuses(this.newAwardCopy.getAwardProjectDirectors(), AwardProjectDirector.class, "awardProjectDirectors");
        success &= this.checkFederalPassThrough();
        success &= this.checkExcludedFromInvoicing();
        success &= this.checkAgencyNotEqualToFederalPassThroughAgency(this.newAwardCopy.getAgency(), this.newAwardCopy.getFederalPassThroughAgency(), "agencyNumber", "federalPassThroughAgencyNumber");
        success &= this.checkStopWorkReason();
        if (this.isContractsGrantsBillingEnhancementActive()) {
            success &= this.performContractsGrantsBillingChecks();
        }
        this.removeErrorMessagesIfInactiveAccountsExist();
        LOG.info("Leaving AwardRule.processCustomRouteDocumentBusinessRules");
        return success;
    }

    protected boolean performContractsGrantsBillingChecks() {
        boolean success = this.checkPrimary(this.newAwardCopy.getAwardFundManagers(), AwardFundManager.class, "awardFundManagers", Award.class);
        success &= this.checkConditionallyRequiredFields();
        success &= this.checkInvoicingOption();
        success &= this.checkBillingFrequency();
        return success &= this.checkCustomerAddress();
    }

    protected boolean checkExcludedFromInvoicing() {
        if (this.newAwardCopy.isExcludedFromInvoicing()) {
            if (ObjectUtils.isNotNull((Object)this.newAwardCopy.getExcludedFromInvoicingReason())) {
                return true;
            }
            this.putFieldError("excludedFromInvoicingReason", "error.cg.excludedFromInvoicingReasonRequired");
            return false;
        }
        return true;
    }

    protected boolean checkAccounts() {
        boolean success = true;
        List<AwardAccount> awardAccounts = this.newAwardCopy.getAwardAccounts();
        if (ObjectUtils.isNull(awardAccounts) || awardAccounts.isEmpty()) {
            String elementLabel = this.getDataDictionaryService().getCollectionElementLabel(Award.class.getName(), "awardAccounts", AwardAccount.class);
            this.putFieldError("awardAccounts", "error.cg.oneRequired", elementLabel);
            success = false;
        }
        return success;
    }

    protected boolean checkProposal() {
        if (this.isProposalAwarded(this.newAwardCopy)) {
            this.putFieldError("proposalNumber", "error.cg.award.proposal.awarded", this.newAwardCopy.getProposalNumber());
            return false;
        }
        return true;
    }

    protected boolean checkFederalPassThrough() {
        boolean success = super.checkFederalPassThrough(this.newAwardCopy.getFederalPassThroughIndicator(), this.newAwardCopy.getAgency(), this.newAwardCopy.getFederalPassThroughAgencyNumber(), Award.class, "federalPassThroughIndicator");
        if (this.newAwardCopy.getFederalPassThroughIndicator() && StringUtils.isBlank((CharSequence)this.newAwardCopy.getFederalPassThroughAgencyNumber())) {
            this.putFieldError("federalPassThroughAgencyNumber", "error.cg.federalPassThroughAgencyIndicatorIsChecked");
            success = false;
        }
        return success;
    }

    public void setupConvenienceObjects() {
        this.newAwardCopy = (Award)((Object)super.getNewBo());
        this.oldAwardCopy = (Award)((Object)super.getOldBo());
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        boolean success = true;
        if (bo instanceof AwardProjectDirector) {
            AwardProjectDirector awardProjectDirector = (AwardProjectDirector)bo;
            success = this.checkAwardProjectDirector(awardProjectDirector);
        } else if (bo instanceof AwardFundManager) {
            AwardFundManager awardFundManager = (AwardFundManager)bo;
            success = this.checkAwardFundManager(awardFundManager);
        } else if (bo instanceof AwardAccount) {
            AwardAccount awardAccount = (AwardAccount)bo;
            success = this.checkAwardAccount(awardAccount);
        } else if (bo instanceof AwardSubcontractor) {
            AwardSubcontractor awardSubcontractor = (AwardSubcontractor)bo;
            success = this.checkAwardSubcontractor(awardSubcontractor);
        } else if (bo instanceof AwardOrganization) {
            AwardOrganization awardOrganization = (AwardOrganization)bo;
            success = this.checkAwardOrganization(awardOrganization);
        }
        return success;
    }

    public boolean processAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        if (line instanceof AwardFundManager) {
            AwardFundManager newAwardFundManager = (AwardFundManager)line;
            if (collectionName.equals("awardFundManagers")) {
                this.newAwardCopy = (Award)document.getNewMaintainableObject().getBusinessObject();
                List<AwardFundManager> awardFundManagers = this.newAwardCopy.getAwardFundManagers();
                int count = 0;
                for (AwardFundManager awardFundManager : awardFundManagers) {
                    if (!awardFundManager.isPrimary()) continue;
                    ++count;
                    if (!newAwardFundManager.isPrimary()) continue;
                    String elementLabel = this.getDataDictionaryService().getCollectionElementLabel(Award.class.getName(), collectionName, AwardFundManager.class);
                    this.putFieldError(collectionName, "error.cg.multiplePrimary", elementLabel);
                    return false;
                }
                if (count > 1) {
                    String elementLabel = this.getDataDictionaryService().getCollectionElementLabel(Award.class.getName(), collectionName, AwardFundManager.class);
                    this.putFieldError(collectionName, "error.cg.multiplePrimary", elementLabel);
                    return false;
                }
            }
        }
        return super.processAddCollectionLineBusinessRules(document, collectionName, line);
    }

    protected boolean checkAwardOrganization(AwardOrganization awardOrganization) {
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        String errorPathPrefix = "add.awardOrganizations.";
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)awardOrganization);
        if (StringUtils.isNotBlank((CharSequence)awardOrganization.getOrganizationCode()) && StringUtils.isNotBlank((CharSequence)awardOrganization.getChartOfAccountsCode())) {
            awardOrganization.refreshReferenceObject("organization");
            if (ObjectUtils.isNull((Object)awardOrganization.getOrganization())) {
                String label = this.getDataDictionaryService().getAttributeLabel(AwardOrganization.class, "organizationCode");
                String message = label + "(" + awardOrganization.getOrganizationCode() + ")";
                this.putFieldError(errorPathPrefix + "organizationCode", "error.existence", message);
            }
        }
        return GlobalVariables.getMessageMap().getErrorCount() == originalErrorCount;
    }

    protected boolean checkAwardSubcontractor(AwardSubcontractor awardSubcontractor) {
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        String errorPathPrefix = "add.awardSubcontractors.";
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)awardSubcontractor);
        if (StringUtils.isNotBlank((CharSequence)awardSubcontractor.getSubcontractorNumber())) {
            awardSubcontractor.refreshReferenceObject("subcontractor");
            if (ObjectUtils.isNull((Object)((Object)awardSubcontractor.getSubcontractor()))) {
                String label = this.getDataDictionaryService().getAttributeLabel(AwardSubcontractor.class, "subcontractorNumber");
                String message = label + "(" + awardSubcontractor.getSubcontractorNumber() + ")";
                this.putFieldError(errorPathPrefix + "subcontractorNumber", "error.existence", message);
            }
        }
        return GlobalVariables.getMessageMap().getErrorCount() == originalErrorCount;
    }

    protected boolean checkAwardAccount(AwardAccount awardAccount) {
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        String errorPathPrefix = "add.awardAccounts.";
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)awardAccount);
        if (StringUtils.isNotBlank((CharSequence)awardAccount.getAccountNumber()) && StringUtils.isNotBlank((CharSequence)awardAccount.getChartOfAccountsCode())) {
            awardAccount.refreshReferenceObject("account");
            if (ObjectUtils.isNull((Object)awardAccount.getAccount())) {
                String label = this.getDataDictionaryService().getAttributeLabel(AwardAccount.class, "accountNumber");
                String message = label + "(" + awardAccount.getChartOfAccountsCode() + "-" + awardAccount.getAccountNumber() + ")";
                this.putFieldError(errorPathPrefix + "accountNumber", "error.existence", message);
            }
        }
        Person projectDirector = awardAccount.getProjectDirector();
        if (StringUtils.isBlank((CharSequence)awardAccount.getPrincipalId()) || ObjectUtils.isNull((Object)projectDirector)) {
            String label = this.getDataDictionaryService().getAttributeLabel(AwardAccount.class, "projectDirector.principalName");
            String message = label + "(" + awardAccount.getPrincipalId() + ")";
            this.putFieldError(errorPathPrefix + "projectDirector.principalName", "error.existence", message);
        }
        return GlobalVariables.getMessageMap().getErrorCount() == originalErrorCount;
    }

    protected boolean checkAwardProjectDirector(AwardProjectDirector awardProjectDirector) {
        boolean success = true;
        Person projectDirector = awardProjectDirector.getProjectDirector();
        if (StringUtils.isBlank((CharSequence)awardProjectDirector.getPrincipalId()) || ObjectUtils.isNull((Object)projectDirector)) {
            String errorPath = "add.awardProjectDirectors.projectDirector.principalName";
            String label = this.getDataDictionaryService().getAttributeLabel(AwardProjectDirector.class, "projectDirector.principalName");
            String message = label + "(" + awardProjectDirector.getPrincipalId() + ")";
            this.putFieldError(errorPath, "error.existence", message);
            success = false;
        }
        return success;
    }

    protected boolean checkForDuplicateAccounts() {
        List<AwardAccount> awardAccounts = this.newAwardCopy.getAwardAccounts();
        HashSet<CallSite> accountHash = new HashSet<CallSite>();
        for (AwardAccount account : awardAccounts) {
            if (account == null || !StringUtils.isNotEmpty((CharSequence)account.getAccountNumber())) continue;
            String accountNumber = account.getAccountNumber();
            String accountChart = account.getChartOfAccountsCode();
            if (accountHash.add((CallSite)((Object)(accountChart + accountNumber)))) continue;
            this.putFieldError("awardAccounts", "error.cg.duplicate.awardAccount", accountChart + "-" + accountNumber);
            return false;
        }
        return true;
    }

    protected boolean checkForDuplicateAwardProjectDirector() {
        List<AwardProjectDirector> awardProjectDirectors = this.newAwardCopy.getAwardProjectDirectors();
        HashSet<String> principalIdHash = new HashSet<String>();
        for (AwardProjectDirector projectDirector : awardProjectDirectors) {
            String principalId;
            if (projectDirector == null || !StringUtils.isNotEmpty((CharSequence)projectDirector.getPrincipalId()) || principalIdHash.add(principalId = projectDirector.getPrincipalId())) continue;
            this.putFieldError("awardProjectDirectors", "error.cg.duplicate.awardProjectDirector", principalId);
            return false;
        }
        return true;
    }

    protected boolean checkForDuplicateAwardOrganization() {
        List<AwardOrganization> awardOrganizations = this.newAwardCopy.getAwardOrganizations();
        HashSet<CallSite> organizationHash = new HashSet<CallSite>();
        for (AwardOrganization awardOrganization : awardOrganizations) {
            if (awardOrganization == null || !StringUtils.isNotEmpty((CharSequence)awardOrganization.getOrganizationCode())) continue;
            String organizationCode = awardOrganization.getOrganizationCode();
            String organizationChart = awardOrganization.getChartOfAccountsCode();
            if (organizationHash.add((CallSite)((Object)(organizationChart + organizationCode)))) continue;
            this.putFieldError("awardOrganizations", "error.cg.duplicate.awardOrganization", organizationChart + "-" + organizationCode);
            return false;
        }
        return true;
    }

    protected boolean checkAwardFundManager(AwardFundManager awardFundManager) {
        boolean success = true;
        Person fundManager = awardFundManager.getFundManager();
        if (this.isContractsGrantsBillingEnhancementActive() && (StringUtils.isBlank((CharSequence)awardFundManager.getPrincipalId()) || ObjectUtils.isNull((Object)fundManager))) {
            String errorPath = "add.awardFundManagers.fundManager.principalName";
            String label = this.getDataDictionaryService().getAttributeLabel(AwardFundManager.class, "fundManager.principalName");
            String message = label + "(" + awardFundManager.getPrincipalId() + ")";
            this.putFieldError(errorPath, "error.existence", message);
            success = false;
        }
        return success;
    }

    protected boolean checkConditionallyRequiredFields() {
        String billingFrequencyCode = this.newAwardCopy.getBillingFrequencyCode();
        String invoicingOptionCode = this.newAwardCopy.getInvoicingOptionCode();
        String billingFrequencyLabel = this.getDataDictionaryService().getAttributeLabel(Award.class, "billingFrequencyCode");
        String invoicingOptionLabel = this.getDataDictionaryService().getAttributeLabel(Award.class, "invoicingOptionCode");
        if (StringUtils.isNotBlank((CharSequence)billingFrequencyCode) && StringUtils.isBlank((CharSequence)invoicingOptionCode)) {
            this.putFieldError("invoicingOptionCode", "error.cg.billing.frequency.and.invoicing.option.required", new String[]{invoicingOptionLabel, billingFrequencyLabel});
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)invoicingOptionCode) && StringUtils.isBlank((CharSequence)billingFrequencyCode)) {
            this.putFieldError("billingFrequencyCode", "error.cg.billing.frequency.and.invoicing.option.required", new String[]{billingFrequencyLabel, invoicingOptionLabel});
            return false;
        }
        return true;
    }

    protected boolean checkInvoicingOption() {
        boolean success = true;
        List errorString = this.getAccountsReceivableModuleBillingService().checkAwardContractControlAccounts((ContractsAndGrantsBillingAward)this.newAwardCopy);
        if (CollectionUtils.isNotEmpty((Collection)errorString) && errorString.size() > 1) {
            success = false;
            this.putFieldError("invoicingOptionCode", (String)errorString.get(0), (String)errorString.get(1));
        }
        if (this.isInvalidInvoicingOption()) {
            success = false;
            this.putFieldError("invoicingOptionCode", "error.cg.invalid.invoicing.option", new String[]{this.newAwardCopy.getInvoicingOptionDescription(), this.newAwardCopy.getBillingFrequency().getFrequencyDescription()});
        }
        return success;
    }

    private boolean isInvalidInvoicingOption() {
        String billingFrequencyCode = this.newAwardCopy.getBillingFrequencyCode();
        boolean isScheduledBilling = StringUtils.equals((CharSequence)billingFrequencyCode, (CharSequence)"MILE") || StringUtils.equals((CharSequence)billingFrequencyCode, (CharSequence)"PDBS");
        boolean isScheduledInvoicingOptionCode = StringUtils.equals((CharSequence)CGIntegrationConstants.AwardInvoicingOption.Types.SCHEDULE.getCode(), (CharSequence)this.newAwardCopy.getInvoicingOptionCode());
        return isScheduledBilling && !isScheduledInvoicingOptionCode || !isScheduledBilling && isScheduledInvoicingOptionCode;
    }

    protected boolean checkStopWorkReason() {
        boolean success = true;
        if (this.newAwardCopy.isStopWorkIndicator() && StringUtils.isBlank((CharSequence)this.newAwardCopy.getStopWorkReason())) {
            success = false;
            this.putFieldError("stopWorkReason", "error.stop.work.reason.required");
        }
        return success;
    }

    protected boolean checkBillingFrequency() {
        String oldBillingFrequencyCode;
        boolean success = true;
        String newBillingFrequencyCode = this.newAwardCopy.getBillingFrequencyCode();
        if (!StringUtils.equals((CharSequence)newBillingFrequencyCode, (CharSequence)(oldBillingFrequencyCode = this.oldAwardCopy.getBillingFrequencyCode()))) {
            String proposalNumber = this.newAwardCopy.getProposalNumber();
            for (ContractsAndGrantsBillingAwardAccount awardAccount : this.newAwardCopy.getActiveAwardAccounts()) {
                if (StringUtils.equals((CharSequence)oldBillingFrequencyCode, (CharSequence)"MILE") && this.getAccountsReceivableModuleBillingService().hasActiveUnbilledMilestones(proposalNumber, awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())) {
                    success = false;
                    this.putFieldError("billingFrequencyCode", "error.cg.active.milestones.exist", this.newAwardCopy.getBillingFrequency().getFrequencyDescription());
                    break;
                }
                if (!StringUtils.equals((CharSequence)oldBillingFrequencyCode, (CharSequence)"PDBS") || !this.getAccountsReceivableModuleBillingService().hasActiveUnbilledBills(proposalNumber, awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())) continue;
                success = false;
                this.putFieldError("billingFrequencyCode", "error.cg.active.bills.exist", this.newAwardCopy.getBillingFrequency().getFrequencyDescription());
                break;
            }
        }
        return success;
    }

    protected boolean checkCustomerAddress() {
        if (this.newAwardCopy.getAgency() != null && !StringUtils.equals((CharSequence)this.newAwardCopy.getCustomerNumber(), (CharSequence)this.newAwardCopy.getAgency().getCustomerNumber())) {
            this.putFieldError("customerAddressIdentifier", "error.cg.billing.customer.address.must.match.agency.customer");
            return false;
        }
        return true;
    }

    private void removeErrorMessagesIfInactiveAccountsExist() {
        List<AwardAccount> newAwardAccounts = this.newAwardCopy.getAwardAccounts();
        Collection oldAwardAccounts = this.oldAwardCopy.getAwardAccounts().stream().map(PersistableBusinessObjectBase::getObjectId).collect(Collectors.toList());
        int pos = 0;
        for (AwardAccount account : newAwardAccounts) {
            if (account != null && oldAwardAccounts.contains(account.getObjectId()) && !account.getAccount().isActive()) {
                String mapKey = String.format("document.newMaintainableObject.%s[%d].%s", "awardAccounts", pos, "accountNumber");
                AutoPopulatingList errorList = (AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get(mapKey);
                if (errorList != null) {
                    errorList.removeIf(t -> Objects.equals(t.getErrorKey(), "error.inactive") && t.getMessageParameters().length > 0 && Objects.equals(t.getMessageParameters()[0], "Account Number"));
                    if (errorList.isEmpty()) {
                        GlobalVariables.getMessageMap().removeAllErrorMessagesForProperty(mapKey);
                    }
                }
            }
            ++pos;
        }
    }

    protected DataDictionaryService getDataDictionaryService() {
        return (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
    }

    AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        return (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
    }

    boolean isProposalAwarded(Award award) {
        return AwardRuleUtil.isProposalAwarded(award);
    }
}

