/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.report.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.report.ContractsGrantsReportDataHolder;
import org.kuali.kfs.module.cg.report.service.ContractsGrantsAwardBalancesReportService;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;

public class ContractsGrantsAwardBalancesReportServiceImpl
implements ContractsGrantsAwardBalancesReportService {
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    protected ReportGenerationService reportGenerationService;
    private ReportInfo contractsGrantsAwardBalancesReportInfo;

    @Override
    public String generateReport(ContractsGrantsReportDataHolder reportDataHolder, ByteArrayOutputStream baos) {
        return this.generateReport(reportDataHolder, this.contractsGrantsAwardBalancesReportInfo, baos);
    }

    @Override
    public String generateReport(ContractsGrantsReportDataHolder reportDataHolder, ReportInfo reportInfo, ByteArrayOutputStream baos) {
        String reportFileName = reportInfo.getReportFileName();
        String reportTemplateClassPath = reportInfo.getReportTemplateClassPath();
        String reportTemplateName = reportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = reportInfo.getResourceBundle();
        String subReportTemplateClassPath = reportInfo.getSubReportTemplateClassPath();
        Map subReports = reportInfo.getSubReports();
        Map<String, Object> reportData = reportDataHolder.getReportData();
        if (ObjectUtils.isNull((Object)reportData.get("reportTitle"))) {
            reportData.put("reportTitle", reportInfo.getReportTitle());
        }
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        this.addParametersToReportData(reportData);
        String template = reportTemplateClassPath + reportTemplateName;
        List<String> data = Collections.singletonList("");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(data);
        this.reportGenerationService.generateReportToOutputStream(reportData, (Object)dataSource, template, (OutputStream)baos);
        return reportFileName;
    }

    public void addParametersToReportData(Map<String, Object> reportData) {
        BusinessObjectEntry boe = this.businessObjectDictionaryService.getBusinessObjectEntry(ContractsAndGrantsBillingAward.class.getName());
        reportData.put("awardProposalId", boe.getAttributeDefinition("proposalNumber").getLabel());
        reportData.put("agencySponsorCode", boe.getAttributeDefinition("agencyNumber").getLabel());
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public ReportGenerationService getReportGenerationService() {
        return this.reportGenerationService;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ReportInfo getContractsGrantsAwardBalancesReportInfo() {
        return this.contractsGrantsAwardBalancesReportInfo;
    }

    public void setContractsGrantsAwardBalancesReportInfo(ReportInfo contractsGrantsInvoiceReportInfo) {
        this.contractsGrantsAwardBalancesReportInfo = contractsGrantsInvoiceReportInfo;
    }
}

