/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cg;

import org.kuali.kfs.integration.ar.ArIntegrationConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * Constants specific to the Contracts & Grants module.
 */
public final class CGConstants {

    public static final String SORT_INDEX_SESSION_KEY = "sortIndex";
    public static final String NUM_SORT_INDEX_CLICK_SESSION_KEY = "numberOfSortClicked";

    // Agency
    public static final String AGENCY_USE_EXISTING_CUSTOMER = "Use Existing Customer";
    public static final String AGENCY_CREATE_NEW_CUSTOMER = "Create New Customer";
    public static final String AGENCY_NO_CUSTOMER = "No Customer";
    public static final String AGENCY_USE_EXISTING_CUSTOMER_CODE = "E";
    public static final String AGENCY_CREATE_NEW_CUSTOMER_CODE = "C";
    public static final String AGENCY_NO_CUSTOMER_CODE = "N";
    public static final String AGENCY_PRIMARY_ADDRESSES_TYPE_CODE = "P";

    // Award
    public static final String AWARD = "AWRD";
    public static final String AWARD_AMOUNT_LESS_THAN_SCHEDULED_AMOUNT_QUESTION =
            "AwardAmountLessThanScheduleAmountQuestion";
    public static final String CG_RESPONSIBILITY_ID = "CG_RESPONSIBILITY_ID";
    public static final String ENTRY_DATE_BEFORE_START_DATE_QUESTION = "entryDateBeforeStartDateQuestion";
    public static final String LOC_BILLING_SCHEDULE_CODE = ArIntegrationConstants.BillingFrequencyValues.LETTER_OF_CREDIT;
    public static final String MILESTONE_BILLING_SCHEDULE_CODE = ArIntegrationConstants.BillingFrequencyValues.MILESTONE;
    public static final String MONTHLY_BILLING_SCHEDULE_CODE = ArIntegrationConstants.BillingFrequencyValues.MONTHLY;
    public static final String PREDETERMINED_BILLING_SCHEDULE_CODE = ArIntegrationConstants.BillingFrequencyValues.PREDETERMINED_BILLING;
    public static final String SUBCONTRACTOR_TOTAL_GREATER_THAN_AWARD_TOTAL_QUESTION =
            "subcontractorTotalGreaterThanAwardTotalQuestion";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private CGConstants() {
    }

    public static class ReportsConstants {
        public static final List<String> awardBalancesReportSubtotalFieldsList = new ArrayList<>();
        static {
            awardBalancesReportSubtotalFieldsList.add("agency.fullName");
            awardBalancesReportSubtotalFieldsList.add("awardStatusCode");
            awardBalancesReportSubtotalFieldsList.add("awardPrimaryProjectDirector.projectDirector.name");
            awardBalancesReportSubtotalFieldsList.add("awardPrimaryFundManager.fundManager.name");
        }

        public static final List<String> reportSearchCriteriaExceptionList = new ArrayList<>();
        static {
            reportSearchCriteriaExceptionList.add("backLocation");
            reportSearchCriteriaExceptionList.add("docFormKey");
            reportSearchCriteriaExceptionList.add("dummyBusinessObject.invoiceReportOption");
        }
    }

    /**
     * This component was added so that the functions using CG_RESPONSIBILITY_ID would work correctly.
     */
    public static class Components {
        public static final String ACCOUNT_CMPNT = "Account";
    }
}
