/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cg.businessobject;

import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddressType;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAgencyAddress;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.CGConstants;
import org.kuali.kfs.sys.businessobject.Country;

import java.sql.Date;

public class AgencyAddress extends PersistableBusinessObjectBase implements Primaryable,
        ContractsAndGrantsAgencyAddress {

    private String agencyNumber;
    private Long agencyAddressIdentifier;
    private String agencyAddressName;
    private String agencyContactName;
    private String agencyLine1StreetAddress;
    private String agencyLine2StreetAddress;
    private String agencyLine3StreetAddress;
    private String agencyLine4StreetAddress;
    private String agencyCityName;
    private String agencyStateCode;
    private String agencyZipCode;
    private String agencyCountryCode;
    private String agencyPhoneNumber;
    private String agencyFaxNumber;
    private String agencyAddressInternationalProvinceName;
    private String agencyInternationalMailCode;
    private String agencyContactEmailAddress;
    private String customerAddressTypeCode;
    private Date agencyAddressEndDate;

    private AccountsReceivableCustomerAddressType customerAddressType;
    private Agency agency;
    private Country agencyCountry;

    @Override
    public String getAgencyNumber() {
        return agencyNumber;
    }

    public void setAgencyNumber(final String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    @Override
    public Long getAgencyAddressIdentifier() {
        return agencyAddressIdentifier;
    }

    public void setAgencyAddressIdentifier(final Long agencyAddressIdentifier) {
        this.agencyAddressIdentifier = agencyAddressIdentifier;
    }

    @Override
    public String getAgencyAddressName() {
        return agencyAddressName;
    }

    public void setAgencyAddressName(final String agencyAddressName) {
        this.agencyAddressName = agencyAddressName;
    }

    @Override
    public String getAgencyLine1StreetAddress() {
        return agencyLine1StreetAddress;
    }

    public void setAgencyLine1StreetAddress(final String agencyLine1StreetAddress) {
        this.agencyLine1StreetAddress = agencyLine1StreetAddress;
    }

    @Override
    public String getAgencyLine2StreetAddress() {
        return agencyLine2StreetAddress;
    }

    public void setAgencyLine2StreetAddress(final String agencyLine2StreetAddress) {
        this.agencyLine2StreetAddress = agencyLine2StreetAddress;
    }

    @Override
    public String getAgencyLine3StreetAddress() {
        return agencyLine3StreetAddress;
    }

    public void setAgencyLine3StreetAddress(final String agencyLine3StreetAddress) {
        this.agencyLine3StreetAddress = agencyLine3StreetAddress;
    }

    @Override
    public String getAgencyLine4StreetAddress() {
        return agencyLine4StreetAddress;
    }

    public void setAgencyLine4StreetAddress(final String agencyLine4StreetAddress) {
        this.agencyLine4StreetAddress = agencyLine4StreetAddress;
    }

    @Override
    public String getAgencyCityName() {
        return agencyCityName;
    }

    public void setAgencyCityName(final String agencyCityName) {
        this.agencyCityName = agencyCityName;
    }

    @Override
    public String getAgencyStateCode() {
        return agencyStateCode;
    }

    public void setAgencyStateCode(final String agencyStateCode) {
        this.agencyStateCode = agencyStateCode;
    }

    @Override
    public String getAgencyZipCode() {
        return agencyZipCode;
    }

    public void setAgencyZipCode(final String agencyZipCode) {
        this.agencyZipCode = agencyZipCode;
    }

    @Override
    public String getAgencyAddressInternationalProvinceName() {
        return agencyAddressInternationalProvinceName;
    }

    public void setAgencyAddressInternationalProvinceName(final String agencyAddressInternationalProvinceName) {
        this.agencyAddressInternationalProvinceName = agencyAddressInternationalProvinceName;
    }

    @Override
    public String getAgencyCountryCode() {
        return agencyCountryCode;
    }

    public void setAgencyCountryCode(final String agencyCountryCode) {
        this.agencyCountryCode = agencyCountryCode;
    }

    @Override
    public String getAgencyInternationalMailCode() {
        return agencyInternationalMailCode;
    }

    public void setAgencyInternationalMailCode(final String agencyInternationalMailCode) {
        this.agencyInternationalMailCode = agencyInternationalMailCode;
    }

    @Override
    public String getAgencyContactEmailAddress() {
        return agencyContactEmailAddress;
    }

    public void setAgencyContactEmailAddress(final String agencyContactEmailAddress) {
        this.agencyContactEmailAddress = agencyContactEmailAddress;
    }

    @Override
    public String getCustomerAddressTypeCode() {
        return customerAddressTypeCode;
    }

    public void setCustomerAddressTypeCode(final String customerAddressTypeCode) {
        this.customerAddressTypeCode = customerAddressTypeCode;
    }

    @Override
    public Date getAgencyAddressEndDate() {
        return agencyAddressEndDate;
    }

    public void setAgencyAddressEndDate(final Date agencyAddressEndDate) {
        this.agencyAddressEndDate = agencyAddressEndDate;
    }

    public AccountsReceivableCustomerAddressType getCustomerAddressType() {
        return customerAddressType;
    }

    @Deprecated
    public void setCustomerAddressType(final AccountsReceivableCustomerAddressType customerAddressType) {
        this.customerAddressType = customerAddressType;
    }

    @Override
    public Agency getAgency() {
        return agency;
    }

    public void setAgency(final Agency agency) {
        this.agency = agency;
    }

    public Country getAgencyCountry() {
        return agencyCountry;
    }

    @Deprecated
    public void setAgencyCountry(final Country agencyCountry) {
        this.agencyCountry = agencyCountry;
    }

    @Override
    public String getAgencyContactName() {
        return agencyContactName;
    }

    public void setAgencyContactName(final String agencyContactName) {
        this.agencyContactName = agencyContactName;
    }

    @Override
    public String getAgencyPhoneNumber() {
        return agencyPhoneNumber;
    }

    public void setAgencyPhoneNumber(final String agencyPhoneNumber) {
        this.agencyPhoneNumber = agencyPhoneNumber;
    }

    @Override
    public String getAgencyFaxNumber() {
        return agencyFaxNumber;
    }

    public void setAgencyFaxNumber(final String agencyFaxNumber) {
        this.agencyFaxNumber = agencyFaxNumber;
    }

    @Override
    public boolean isPrimary() {
        return ObjectUtils.isNotNull(customerAddressTypeCode) && customerAddressTypeCode.equals(
                CGConstants.AGENCY_PRIMARY_ADDRESSES_TYPE_CODE);
    }
}
