/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cg.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

/**
 * A generalized purpose for a proposal.
 */
public class ProposalPurpose extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String proposalPurposeCode;
    private String proposalPurposeDescription;
    private boolean active;

    public String getProposalPurposeCode() {
        return proposalPurposeCode;
    }

    public void setProposalPurposeCode(final String proposalPurposeCode) {
        this.proposalPurposeCode = proposalPurposeCode;
    }

    public String getProposalPurposeDescription() {
        return proposalPurposeDescription;
    }

    public void setProposalPurposeDescription(final String proposalPurposeDescription) {
        this.proposalPurposeDescription = proposalPurposeDescription;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

}
