/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cg.businessobject.options;

import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.module.cg.businessobject.GrantDescription;
import org.kuali.kfs.core.api.util.ConcreteKeyValue;
import org.kuali.kfs.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Gets a custom-formatted list of {@link GrantDescription} values.
 */
public class GrantDescriptionValuesFinder extends KeyValuesBase {

    private KeyValuesService keyValuesService;

    @Override
    public List<KeyValue> getKeyValues() {
        final Collection<GrantDescription> codes = keyValuesService.findAll(GrantDescription.class);

        final List<KeyValue> labels = new ArrayList<>();
        labels.add(new ConcreteKeyValue("", ""));

        for (final GrantDescription code : codes) {
            if (code.isActive()) {
                labels.add(new ConcreteKeyValue(code.getGrantDescriptionCode(), code.getGrantDescriptionCode() +
                        " - " + code.getGrantDescription()));
            }
        }

        return labels;
    }

    public void setKeyValuesService(final KeyValuesService keyValuesService) {
        this.keyValuesService = keyValuesService;
    }
}
