/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cg.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.module.cg.service.ContractsAndGrantsLookupService;

import java.util.Map;

/**
 * Service with methods related to Contracts & Grants Lookups.
 */
public class ContractsAndGrantsLookupServiceImpl implements ContractsAndGrantsLookupService {

    private PersonService personService;

    @Override
    public boolean setupSearchFields(
            final Map<String, String> fieldValues,
            final String userNameField,
            final String universalUserIdField
    ) {
        if (StringUtils.isNotBlank(fieldValues.get(userNameField))) {
            final Person person = personService.getPersonByPrincipalName(fieldValues.get(userNameField));

            if (person == null) {
                return false;
            }

            // place the universal ID into the fieldValues map and remove the dummy attribute
            fieldValues.put(universalUserIdField, person.getPrincipalId());
            fieldValues.remove(userNameField);
        }

        return true;
    }

    public void setPersonService(final PersonService personService) {
        this.personService = personService;
    }
}
