/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.service.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cg.batch.CfdaBatchStep;
import org.kuali.kfs.module.cg.businessobject.CFDA;
import org.kuali.kfs.module.cg.service.impl.CfdaServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class CfdaServiceImplTest {
    private CfdaServiceImpl cut;
    @Mock
    private ParameterService parameterServiceMock;
    @Mock
    private DataDictionaryService dataDictionaryServiceMock;
    @Mock
    private BusinessObjectService businessObjectServiceMock;

    CfdaServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new CfdaServiceImpl();
        this.cut.setParameterService(this.parameterServiceMock);
        this.cut.setDataDictionaryService(this.dataDictionaryServiceMock);
        this.cut.setBusinessObjectService(this.businessObjectServiceMock);
    }

    @Test
    void getGovCodes() {
        Mockito.when((Object)this.dataDictionaryServiceMock.getAttributeMaxLength(CFDA.class, "cfdaProgramTitleName")).thenReturn((Object)25);
        String testFile = this.getClass().getResource(".." + File.separator + ".." + File.separator + "fixture" + File.separator + "AssistanceListings_DataGov_PUBLIC_CURRENT_small.csv").toString();
        Mockito.when((Object)this.parameterServiceMock.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL")).thenReturn((Object)testFile);
        Map map = this.cut.getGovCodes();
        Assertions.assertEquals((int)8, (int)map.size());
        CFDA cfda = (CFDA)map.get("10.053");
        Assertions.assertEquals((Object)"Dairy Indemnity Program", (Object)cfda.getCfdaProgramTitleName());
        Assertions.assertEquals((Object)"AUTOMATIC", (Object)cfda.getCfdaMaintenanceTypeId());
        Assertions.assertTrue((boolean)cfda.isActive());
        CFDA cfdaTrimmed = (CFDA)map.get("10.051");
        Assertions.assertEquals((Object)"Commodity Loans and Loan ", (Object)cfdaTrimmed.getCfdaProgramTitleName());
    }

    @Test
    void getGovCodes_BAD_FILE() {
        String testFile = this.getClass().getResource(".." + File.separator + ".." + File.separator + "fixture" + File.separator + "AssistanceListings_DataGov_PUBLIC_CURRENT_bad.csv").toString();
        Mockito.when((Object)this.parameterServiceMock.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL")).thenReturn((Object)testFile);
        Exception ex = (Exception)Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.cut.getGovCodes());
        Assertions.assertTrue((boolean)ex.getMessage().contains("out of bounds"));
    }

    @Test
    void getGovCodes_NO_RESULT() {
        String testFile = "does_no_exist.csv";
        Mockito.when((Object)this.parameterServiceMock.getParameterValueAsString(CfdaBatchStep.class, "SOURCE_URL")).thenReturn((Object)"does_no_exist.csv");
        Exception ex = (Exception)Assertions.assertThrows(RuntimeException.class, () -> this.cut.getGovCodes());
        Assertions.assertTrue((boolean)ex.getMessage().contains("The file could not be retrieved"));
    }

    @Test
    void getKfsCodes() {
        CFDA cfda1 = new CFDA("10.030", "Test Title 1", "AUTOMATIC", true);
        CFDA cfda2 = new CFDA("10.031", "Manual Test Title 2", "MANUAL", true);
        CFDA cfda3 = new CFDA("10.040", "Test Title 3", "AUTOMATIC", false);
        List<CFDA> testCfdas = List.of(cfda1, cfda2, cfda3);
        Mockito.when((Object)this.businessObjectServiceMock.findAll(CFDA.class)).thenReturn(testCfdas);
        Map map = this.cut.getKfsCodes();
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)this.cfdaEquals(cfda1, (CFDA)map.get("10.030")));
        Assertions.assertTrue((boolean)this.cfdaEquals(cfda2, (CFDA)map.get("10.031")));
        Assertions.assertTrue((boolean)this.cfdaEquals(cfda3, (CFDA)map.get("10.040")));
    }

    private boolean cfdaEquals(CFDA cfda1, CFDA cfda2) {
        return cfda1.getCfdaNumber().equalsIgnoreCase(cfda2.getCfdaNumber()) && cfda1.getCfdaProgramTitleName().equalsIgnoreCase(cfda2.getCfdaProgramTitleName()) && cfda1.getCfdaMaintenanceTypeId().equalsIgnoreCase(cfda2.getCfdaMaintenanceTypeId()) && cfda1.isActive() == cfda2.isActive();
    }
}

