/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.dataaccess.impl;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.businessobject.DocumentStoreChange;
import org.kuali.kfs.sys.datatools.liquimongo.dataaccess.DocumentStoreUpdateProcessDao;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class DocumentStoreUpdateProcessDaoMongo
implements DocumentStoreUpdateProcessDao {
    private static final Logger LOG = Logger.getLogger(DocumentStoreUpdateProcessDaoMongo.class);
    private MongoTemplate mongoTemplate;

    @Override
    public boolean isSchemaChangeLocked() {
        LOG.debug((Object)"isSchemaChangeLocked() started");
        Query q = new Query();
        q.addCriteria(Criteria.where((String)"locked").is((Object)true));
        return this.mongoTemplate.findOne(q, DBObject.class, "Schema") != null;
    }

    @Override
    public void lockSchemaChange() {
        LOG.debug((Object)"lockSchemaChange() started");
        DBObject lock = (DBObject)JSON.parse((String)"{ \"locked\": true }");
        this.mongoTemplate.save((Object)lock, "Schema");
    }

    @Override
    public void unlockSchemaChange() {
        LOG.debug((Object)"unlockSchemaChange() started");
        Query q = new Query();
        q.addCriteria(Criteria.where((String)"locked").is((Object)true));
        this.mongoTemplate.remove(q, "Schema");
    }

    @Override
    public boolean hasSchemaChangeHappened(DocumentStoreChange change) {
        LOG.debug((Object)"hasSchemaChangeHappened() started");
        Query q = new Query();
        q.addCriteria(Criteria.where((String)"fileName").is((Object)change.getFileName()));
        q.addCriteria(Criteria.where((String)"changeId").is((Object)change.getChangeId()));
        q.addCriteria(Criteria.where((String)"hash").is((Object)change.getHash()));
        return this.mongoTemplate.findOne(q, DocumentStoreChange.class, "Schema") != null;
    }

    @Override
    public void saveSchemaChange(DocumentStoreChange change) {
        LOG.debug((Object)"saveSchemaChange() started");
        this.mongoTemplate.save((Object)change, "Schema");
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

