/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.DBObject;
import java.util.Date;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.change.DocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.JsonUtils;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;

public abstract class AbstractDocumentStoreChangeHandler
implements DocumentStoreChangeHandler {
    protected MongoOperations mongoTemplate;
    private static final Logger LOG = Logger.getLogger(AbstractDocumentStoreChangeHandler.class);
    public static final String CHANGE_TYPE = "changeType";
    public static final String CHANGE_DATESTAMP_KEY = "deleteDateStampKey";

    protected boolean isKeyValueCorrect(JsonNode node, String key, String value) {
        return node.get(key).asText().equals(value);
    }

    protected void verifyKeyExistence(JsonNode node, String key) {
        if (node.get(key) == null) {
            LOG.error((Object)("verifyKeyExistence() " + key + " is required in node: " + node));
            throw new IllegalArgumentException(key + " is missing from change json");
        }
    }

    protected void backupDocument(Query q, JsonNode change, String collectionName, String changeKey) {
        String backupCollectionName = "backup_" + collectionName;
        DBObject object = (DBObject)this.mongoTemplate.findOne(q, DBObject.class, collectionName);
        if (object != null) {
            object.put(changeKey, (Object)JsonUtils.calculateHash(change));
            object.put(CHANGE_DATESTAMP_KEY, (Object)new Date().getTime());
            this.mongoTemplate.save((Object)object, backupCollectionName);
        }
    }

    public void setMongoTemplate(MongoOperations mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

