/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.change.AbstractDocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.DocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.JsonUtils;
import org.springframework.data.mongodb.core.query.Query;

public class AddDocumentHandler
extends AbstractDocumentStoreChangeHandler
implements DocumentStoreChangeHandler {
    private static final Logger LOG = Logger.getLogger(AddDocumentHandler.class);
    public static final String ADD_DOCUMENT = "addDocument";

    @Override
    public boolean handlesChange(JsonNode change) {
        return this.isKeyValueCorrect(change, "changeType", ADD_DOCUMENT);
    }

    @Override
    public void makeChange(JsonNode change) {
        LOG.debug((Object)"makeChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, "document");
        this.verifyKeyExistence(change, "query");
        String collectionName = change.get("collectionName").asText();
        JsonNode document = change.get("document");
        DBObject dbObject = (DBObject)JSON.parse((String)document.toString());
        this.mongoTemplate.save((Object)dbObject, collectionName);
    }

    @Override
    public void revertChange(JsonNode change) {
        LOG.debug((Object)"revertChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, "query");
        String collectionName = change.get("collectionName").asText();
        JsonNode query = change.get("query");
        Query q = JsonUtils.getQueryFromJson(query);
        this.mongoTemplate.remove(q, collectionName);
    }
}

