/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.change.AbstractDocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.DocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.JsonUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class UpdateDocumentHandler
extends AbstractDocumentStoreChangeHandler
implements DocumentStoreChangeHandler {
    private static final Logger LOG = Logger.getLogger(UpdateDocumentHandler.class);
    public static final String UPDATE_DOCUMENTS = "updateDocuments";
    public static final String UPDATE_CHANGE_KEY = "updateChangeKey";

    @Override
    public boolean handlesChange(JsonNode change) {
        return this.isKeyValueCorrect(change, "changeType", UPDATE_DOCUMENTS);
    }

    @Override
    public void makeChange(JsonNode change) {
        LOG.debug((Object)"makeChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, "query");
        this.verifyKeyExistence(change, "document");
        String collectionName = change.get("collectionName").asText();
        JsonNode query = change.get("query");
        Query q = JsonUtils.getQueryFromJson(query);
        this.backupDocument(q, change, collectionName, UPDATE_CHANGE_KEY);
        JsonNode document = change.get("document");
        this.mongoTemplate.remove(q, collectionName);
        DBObject dbObject = (DBObject)JSON.parse((String)document.toString());
        this.mongoTemplate.save((Object)dbObject, collectionName);
    }

    @Override
    public void revertChange(JsonNode change) {
        LOG.debug((Object)"revertChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, "query");
        String collectionName = change.get("collectionName").asText();
        String backupCollectionName = "backup_" + collectionName;
        JsonNode query = change.get("query");
        Query q = JsonUtils.getQueryFromJson(query).addCriteria(Criteria.where((String)UPDATE_CHANGE_KEY).is((Object)JsonUtils.calculateHash(change))).with(new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "deleteDateStampKey")}));
        DBObject object = (DBObject)this.mongoTemplate.findOne(q, DBObject.class, backupCollectionName);
        if (object != null) {
            Object datestamp = object.get("deleteDateStampKey");
            object.removeField(UPDATE_CHANGE_KEY);
            object.removeField("deleteDateStampKey");
            this.mongoTemplate.remove(JsonUtils.getQueryFromJson(query), collectionName);
            this.mongoTemplate.save((Object)object, collectionName);
            q = JsonUtils.getQueryFromJson(query).addCriteria(Criteria.where((String)"deleteDateStampKey").gte(datestamp));
            this.mongoTemplate.remove(q, backupCollectionName);
        }
    }
}

