/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.businessobject.DocumentStoreChange;
import org.kuali.kfs.sys.datatools.liquimongo.change.DocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.dataaccess.DocumentStoreUpdateProcessDao;
import org.kuali.kfs.sys.datatools.liquimongo.service.DocumentStoreSchemaUpdateService;
import org.kuali.kfs.sys.datatools.util.ResourceLoaderUtil;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DocumentStoreSchemaUpdateServiceImpl
implements DocumentStoreSchemaUpdateService {
    private static final Logger LOG = Logger.getLogger(DocumentStoreSchemaUpdateServiceImpl.class);
    private DocumentStoreUpdateProcessDao documentStoreUpdateProcessDao;
    private List<DocumentStoreChangeHandler> handlers;
    private String updatesPath;
    private String updatesList;
    private String revertPath;
    private String revertList;

    @Override
    public void updateDocumentStoreSchema() {
        LOG.debug((Object)"updateDocumentStoreSchema() started");
        if (this.documentStoreUpdateProcessDao.isSchemaChangeLocked()) {
            LOG.debug((Object)"updateDocumentStoreSchema() not running because schema is locked");
            return;
        }
        try {
            this.documentStoreUpdateProcessDao.lockSchemaChange();
            List<String> updateFiles = this.getUpdateFiles(this.updatesPath + this.updatesList);
            for (String updateFile : updateFiles) {
                LOG.debug((Object)("updateDocumentStoreSchema() " + updateFile));
                this.process(updateFile);
            }
        }
        catch (IOException ex) {
            LOG.error((Object)"updateDocumentStoreSchema() Unable to read and process updates", (Throwable)ex);
            throw new IllegalArgumentException("Unable to open update file " + this.updatesPath + this.updatesList, ex);
        }
        finally {
            this.documentStoreUpdateProcessDao.unlockSchemaChange();
        }
    }

    @Override
    public void revertDocumentStoreSchema() {
        LOG.debug((Object)"revertDocumentStoreSchema() started");
        if (this.documentStoreUpdateProcessDao.isSchemaChangeLocked()) {
            LOG.debug((Object)"revertDocumentStoreSchema() not running because schema is locked");
            return;
        }
        try {
            this.documentStoreUpdateProcessDao.lockSchemaChange();
            List<String> revertFiles = this.getUpdateFiles(this.revertPath + this.revertList);
            Collections.reverse(revertFiles);
            for (String revertFile : revertFiles) {
                LOG.debug((Object)("revertDocumentStoreSchema() " + revertFile));
                this.revert(revertFile);
            }
        }
        catch (IOException ex) {
            LOG.error((Object)"revertDocumentStoreSchema() Unable to read and process reversions", (Throwable)ex);
            throw new IllegalArgumentException("Unable to open revert file " + this.revertPath + this.revertList, ex);
        }
        finally {
            this.documentStoreUpdateProcessDao.unlockSchemaChange();
        }
    }

    @Override
    public void updateDocumentStoreSchemaForLocation(String location) {
        if (location.startsWith("/")) {
            location = "file:" + location;
        }
        FileInfo fileInfo = DocumentStoreSchemaUpdateServiceImpl.parseFilePath(location);
        this.setUpdatesPath(fileInfo.filePath);
        this.setUpdatesList(fileInfo.fileName);
        this.updateDocumentStoreSchema();
    }

    @Override
    public void revertDocumentStoreSchemaForLocation(String location) {
        if (location.startsWith("/")) {
            location = "file:" + location;
        }
        FileInfo fileInfo = DocumentStoreSchemaUpdateServiceImpl.parseFilePath(location);
        this.setRevertPath(fileInfo.filePath);
        this.setRevertList(fileInfo.fileName);
        this.revertDocumentStoreSchema();
    }

    public void process(String updateFile) throws IOException {
        LOG.debug((Object)"process() started");
        Resource resource = ResourceLoaderUtil.getFileResource(this.updatesPath + updateFile);
        if (resource == null) {
            throw new FileNotFoundException("Invalid resource specified: " + this.updatesPath + updateFile);
        }
        InputStream is = resource.getInputStream();
        if (is == null) {
            throw new IOException("process() Unable to read file: " + this.updatesPath + updateFile);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readValue(is, JsonNode.class);
        JsonNode arrayOfChanges = rootNode.get("changeLog");
        Iterator items = arrayOfChanges.elements();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            DocumentStoreChange change = new DocumentStoreChange(updateFile, item);
            this.applyChangeSetIfNecessary(change);
        }
    }

    public void revert(String revertFile) throws IOException {
        LOG.debug((Object)"revert() started");
        Resource resource = ResourceLoaderUtil.getFileResource(this.revertPath + revertFile);
        if (resource == null) {
            throw new FileNotFoundException("Invalid resource specified: " + this.revertPath + revertFile);
        }
        InputStream is = resource.getInputStream();
        if (is == null) {
            throw new IOException("revert() Unable to read file: " + this.revertPath + revertFile);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readValue(is, JsonNode.class);
        JsonNode arrayOfChanges = rootNode.get("changeLog");
        Iterator items = arrayOfChanges.elements();
        ArrayList itemsReversed = new ArrayList();
        while (items.hasNext()) {
            itemsReversed.add(0, items.next());
        }
        for (JsonNode item : itemsReversed) {
            DocumentStoreChange change = new DocumentStoreChange(revertFile, item);
            this.revertChangeSetIfNecessary(change);
        }
    }

    private void applyChangeSetIfNecessary(DocumentStoreChange changeSet) {
        LOG.debug((Object)"applyChangeSetIfNecessary() started");
        if (!this.documentStoreUpdateProcessDao.hasSchemaChangeHappened(changeSet)) {
            LOG.debug((Object)("applyChangeSetIfNecessary() Making change: " + changeSet));
            changeSet.getAllChanges().forEach(change -> this.applyChange((JsonNode)change));
            this.documentStoreUpdateProcessDao.saveSchemaChange(changeSet);
        }
    }

    private void revertChangeSetIfNecessary(DocumentStoreChange changeSet) {
        LOG.debug((Object)"revertChangeSetIfNecessary() started");
        if (this.documentStoreUpdateProcessDao.hasSchemaChangeHappened(changeSet)) {
            LOG.debug((Object)("revertChangeSetIfNecessary() Reverting change: " + changeSet));
            List<JsonNode> changes = changeSet.getAllChanges();
            Collections.reverse(changes);
            changes.forEach(change -> this.revertChange((JsonNode)change));
            this.documentStoreUpdateProcessDao.removeSchemaChange(changeSet);
        }
    }

    private void applyChange(JsonNode change) {
        boolean changeMade = false;
        for (DocumentStoreChangeHandler handler : this.handlers) {
            if (!handler.handlesChange(change)) continue;
            handler.makeChange(change);
            changeMade = true;
            break;
        }
        if (!changeMade) {
            LOG.error((Object)("applyChange() No document handler found for this change: " + change));
            throw new IllegalArgumentException("No handler registered to handle this change");
        }
    }

    private void revertChange(JsonNode change) {
        boolean changeMade = false;
        for (DocumentStoreChangeHandler handler : this.handlers) {
            if (!handler.handlesChange(change)) continue;
            handler.revertChange(change);
            changeMade = true;
            break;
        }
        if (!changeMade) {
            LOG.error((Object)("applyChange() No document handler found for this change: " + change));
            throw new IllegalArgumentException("No handler registered to handle this change");
        }
    }

    private List<String> getUpdateFiles(String listFile) throws IOException {
        InputStream is;
        LOG.debug((Object)"getUpdateFiles() started");
        ArrayList<String> files = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        Resource resource = ResourceLoaderUtil.getFileResource(listFile);
        if (resource == null) {
            LOG.warn((Object)("Invalid resource specified: " + this.updatesPath + listFile));
        }
        if ((is = resource.getInputStream()) == null) {
            LOG.warn((Object)("getUpdateFiles() Unable to read file: " + this.updatesPath + listFile));
        }
        JsonNode rootNode = (JsonNode)mapper.readValue(is, JsonNode.class);
        JsonNode arrayOfChanges = rootNode.get("updateFiles");
        Iterator items = arrayOfChanges.elements();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            String filename = item.asText();
            files.add(filename);
        }
        return files;
    }

    private static FileInfo parseFilePath(String fullPath) {
        FileInfo fileInfo = new FileInfo();
        int splitIndex = fullPath.lastIndexOf("/");
        fileInfo.filePath = fullPath.substring(0, splitIndex + 1);
        fileInfo.fileName = fullPath.substring(splitIndex + 1);
        return fileInfo;
    }

    public void setUpdatesPath(String updatesPath) {
        this.updatesPath = updatesPath;
    }

    public void setUpdatesList(String updatesList) {
        this.updatesList = updatesList;
    }

    public void setRevertPath(String revertPath) {
        this.revertPath = revertPath;
    }

    public void setRevertList(String revertList) {
        this.revertList = revertList;
    }

    public void setDocumentStoreUpdateProcessDao(DocumentStoreUpdateProcessDao documentStoreUpdateProcessDao) {
        this.documentStoreUpdateProcessDao = documentStoreUpdateProcessDao;
    }

    public void setHandlers(List<DocumentStoreChangeHandler> handlers) {
        this.handlers = handlers;
    }

    private static class FileInfo {
        public String filePath;
        public String fileName;

        private FileInfo() {
        }
    }
}

