/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.businessobject;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.change.JsonUtils;
import org.springframework.data.annotation.Transient;

public class DocumentStoreChange {
    private static final Logger LOG = Logger.getLogger(DocumentStoreChange.class);
    private String fileName;
    private Date changeDate = new Date();
    private String changeId;
    private String hash;
    @Transient
    private JsonNode changeNode;

    public DocumentStoreChange() {
    }

    public DocumentStoreChange(String fileName, JsonNode node) {
        this();
        this.fileName = fileName;
        this.changeNode = node;
        this.changeId = node.get("id").asText();
        this.hash = JsonUtils.calculateHash(node);
    }

    public List<JsonNode> getAllChanges() {
        ArrayList<JsonNode> changeList = new ArrayList<JsonNode>();
        JsonNode changes = this.changeNode.get("changes");
        Iterator items = changes.elements();
        while (items.hasNext()) {
            changeList.add((JsonNode)items.next());
        }
        return changeList;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeId() {
        return this.changeId;
    }

    public void setChangeId(String changeId) {
        this.changeId = changeId;
    }

    public JsonNode getChangeNode() {
        return this.changeNode;
    }

    public void setChangeNode(JsonNode changeNode) {
        this.changeNode = changeNode;
    }

    public String toString() {
        return "DocumentStoreChange{changeId='" + this.changeId + '\'' + ", fileName='" + this.fileName + '\'' + ", changeDate=" + this.changeDate + ", hash=" + this.hash + '}';
    }
}

