/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.change.AbstractNodeChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.DocumentStoreChangeHandler;
import org.springframework.data.mongodb.core.index.IndexDefinition;

public class AddIndexHandler
extends AbstractNodeChangeHandler
implements DocumentStoreChangeHandler {
    private static final Logger LOG = Logger.getLogger(AddIndexHandler.class);
    public static final String ADD_INDEX = "addIndex";
    public static final String KEY = "key";
    public static final String OPTIONS = "options";

    @Override
    public boolean handlesChange(JsonNode change) {
        return this.isKeyValueCorrect(change, "changeType", ADD_INDEX);
    }

    @Override
    public void makeChange(JsonNode change) {
        LOG.debug((Object)"makeChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, KEY);
        this.verifyKeyExistence(change, OPTIONS);
        String collectionName = change.get("collectionName").asText();
        final JsonNode keys = change.get(KEY);
        final JsonNode options = change.get(OPTIONS);
        IndexDefinition newIndex = new IndexDefinition(){

            public DBObject getIndexKeys() {
                return (DBObject)JSON.parse((String)keys.toString());
            }

            public DBObject getIndexOptions() {
                return (DBObject)JSON.parse((String)options.toString());
            }
        };
        this.mongoTemplate.indexOps(collectionName).ensureIndex(newIndex);
    }
}

