/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.change.AbstractNodeChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.DocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.JsonUtils;
import org.springframework.data.mongodb.core.query.Query;

public class AddNodeHandler
extends AbstractNodeChangeHandler
implements DocumentStoreChangeHandler {
    private static final Logger LOG = Logger.getLogger(AddNodeHandler.class);
    public static final String ADD_BEFORE_NODE = "addBeforeNode";
    public static final String ADD_NODE = "addNode";

    @Override
    public boolean handlesChange(JsonNode change) {
        return this.isKeyValueCorrect(change, "changeType", ADD_NODE);
    }

    @Override
    public void makeChange(JsonNode change) {
        LOG.debug((Object)"makeChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, "query");
        this.verifyKeyExistence(change, "value");
        String collectionName = change.get("collectionName").asText();
        DBObject nodeToAdd = (DBObject)JSON.parse((String)change.get("value").toString());
        JsonNode query = change.get("query");
        Query q = JsonUtils.getQueryFromJson(query);
        String documentJson = ((DBObject)this.mongoTemplate.findOne(q, DBObject.class, collectionName)).toString();
        String newJson = this.addNode(change, documentJson, nodeToAdd, "path", ADD_BEFORE_NODE).toString();
        DBObject result = (DBObject)JSON.parse((String)newJson);
        this.mongoTemplate.remove(q, collectionName);
        this.mongoTemplate.save((Object)result, collectionName);
    }
}

