/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.log4j.Logger;
import org.kuali.kfs.sys.datatools.liquimongo.change.AbstractDocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.DocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.JsonUtils;
import org.springframework.data.mongodb.core.query.Query;

public class DeleteDocumentsHandler
extends AbstractDocumentStoreChangeHandler
implements DocumentStoreChangeHandler {
    private static final Logger LOG = Logger.getLogger(DeleteDocumentsHandler.class);
    public static final String DELETE_DOCUMENTS = "deleteDocument";

    @Override
    public boolean handlesChange(JsonNode change) {
        return this.isKeyValueCorrect(change, "changeType", DELETE_DOCUMENTS);
    }

    @Override
    public void makeChange(JsonNode change) {
        LOG.debug((Object)"makeChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, "query");
        String collectionName = change.get("collectionName").asText();
        JsonNode query = change.get("query");
        Query q = JsonUtils.getQueryFromJson(query);
        this.mongoTemplate.remove(q, collectionName);
    }
}

