/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import org.kuali.kfs.sys.datatools.liquimongo.change.AbstractDocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.liquimongo.change.JsonUtils;

public abstract class AbstractNodeChangeHandler
extends AbstractDocumentStoreChangeHandler {
    protected static final String PATH = "path";
    protected static final String VALUE = "value";

    protected DBObject addNode(JsonNode change, String documentJson, DBObject nodeToAdd, String pathKey, String beforeNodeKey) {
        this.verifyKeyExistence(change, pathKey);
        String revertPath = change.get(pathKey).asText();
        DocumentContext dc = JsonPath.parse((String)documentJson);
        Object nodeToRestore = this.findNode(dc, revertPath);
        if (nodeToRestore == null || !(nodeToRestore instanceof JSONArray)) {
            throw new RuntimeException("Revert path must point to an array: " + revertPath);
        }
        JSONArray arrayToRestore = (JSONArray)nodeToRestore;
        boolean changeApplied = false;
        if (change.has(beforeNodeKey)) {
            JsonNode revertBeforeNode = change.get(beforeNodeKey);
            Map<String, Object> conditions = JsonUtils.getMapFromJson(revertBeforeNode);
            for (int i = 0; i < arrayToRestore.size(); ++i) {
                Map mapToCheck;
                Object objectToCheck = arrayToRestore.get(i);
                if (!(objectToCheck instanceof Map) || !this.checkConditions(mapToCheck = (Map)objectToCheck, conditions)) continue;
                arrayToRestore.add(i, (Object)nodeToAdd);
                changeApplied = true;
                break;
            }
        }
        if (!changeApplied) {
            arrayToRestore.add((Object)nodeToAdd);
        }
        String newJson = dc.jsonString();
        DBObject result = (DBObject)JSON.parse((String)newJson);
        return result;
    }

    private boolean checkConditions(Map mapToCheck, Map<String, Object> conditions) {
        for (Map.Entry<String, Object> entry : conditions.entrySet()) {
            if (entry.getValue().equals(mapToCheck.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    protected Object findNode(DocumentContext dc, String path) {
        Set dcOptions = dc.configuration().getOptions();
        dc.configuration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS});
        List nodes = (List)dc.read(path, new Predicate[0]);
        dc.configuration().setOptions(dcOptions.toArray(new Option[dcOptions.size()]));
        if (nodes.size() != 1) {
            throw new RuntimeException("Cannot find unique node: " + path);
        }
        return nodes.get(0);
    }
}

