/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.util.JSON;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.change.AddDocumentHandler;
import org.springframework.data.mongodb.core.MongoOperations;

public class AddDocumentHandlerTest {
    private AddDocumentHandler addDocumentHandler;
    private MongoOperations mongoTemplate;

    @Before
    public void setup() {
        this.addDocumentHandler = new AddDocumentHandler();
        this.mongoTemplate = (MongoOperations)EasyMock.createMock(MongoOperations.class);
    }

    @Test
    public void testHandlesAddDocument() throws Exception {
        String testJson = "{ \"changeType\": \"addDocument\",\"collectionName\": \"collection\",\"query\": { },\"document\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should handle addDocument element", (Object)true, (Object)this.addDocumentHandler.handlesChange(testNode));
    }

    @Test
    public void testDoesNotHandleDeleteDocument() throws Exception {
        String testJson = "{ \"changeType\": \"deleteDocument\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should not handle deleteDocument element", (Object)false, (Object)this.addDocumentHandler.handlesChange(testNode));
    }

    @Test
    public void testMakeChangeAddsDocument() throws Exception {
        this.mongoTemplate.save(JSON.parse((String)"{ }"), "collection");
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        this.addDocumentHandler.setMongoTemplate(this.mongoTemplate);
        String testJson = "{ \"changeType\": \"addDocument\",\"collectionName\": \"collection\",\"query\": { },\"document\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.addDocumentHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    @Test
    public void testMissingFieldGivesGoodError() throws Exception {
        String testJson = "{ \"changeType\": \"addDocument\",\"document\": { \"myId\": \"10\"} }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        try {
            this.addDocumentHandler.makeChange(testNode);
            Assert.fail((String)"Method should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

