/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.change.AddIndexHandler;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;

public class AddIndexHandlerTest {
    private AddIndexHandler addIndexHandler;
    private MongoOperations mongoTemplate;

    @Before
    public void setup() {
        this.addIndexHandler = new AddIndexHandler();
        this.mongoTemplate = (MongoOperations)EasyMock.createMock(MongoOperations.class);
    }

    @Test
    public void testHandlesAddIndex() throws Exception {
        String testJson = "{ \"changeType\": \"addIndex\",\"collectionName\": \"collection\",\"query\": { },\"document\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should handle addIndex element", (Object)true, (Object)this.addIndexHandler.handlesChange(testNode));
    }

    @Test
    public void testDoesNotHandleDeleteDocument() throws Exception {
        String testJson = "{ \"changeType\": \"deleteDocument\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should not handle deleteDocument element", (Object)false, (Object)this.addIndexHandler.handlesChange(testNode));
    }

    @Test
    public void testMakeChangeAddsIndex() throws Exception {
        EasyMock.expect((Object)this.mongoTemplate.indexOps("collection")).andReturn((Object)new IndexOperations(){

            public void ensureIndex(IndexDefinition indexDefinition) {
            }

            public void dropIndex(String s) {
            }

            public void dropAllIndexes() {
            }

            public void resetIndexCache() {
            }

            public List<IndexInfo> getIndexInfo() {
                return null;
            }
        });
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        this.addIndexHandler.setMongoTemplate(this.mongoTemplate);
        String testJson = "{ \"changeType\": \"addIndex\",\"collectionName\": \"collection\",\"key\": { \"createdAt\": 1 },\"options\": { \"name\": \"expireIndex\" } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.addIndexHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    @Test
    public void testMissingFieldGivesGoodError() throws Exception {
        String testJson = "{ \"changeType\": \"addIndex\",\"key\": { \"myId\": \"1\"} }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        try {
            this.addIndexHandler.makeChange(testNode);
            Assert.fail((String)"Method should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

