/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.DefaultResourceLoader;

public class PropertyLoadingFactoryBean
implements FactoryBean<Properties> {
    private static final Properties BASE_PROPERTIES = new Properties();
    private static final String FINANCIALS_DEFAULT_CONFIG = "/org/kuali/kfs/sys/datatools/financials-default-config";
    private static final String FINANCIALS_SECURITY_DEFAULT_CONFIG = "/org/kuali/kfs/sys/datatools/financials-security-default-config";
    private static final String SECURITY_PROPERTY_FILE_NAME_KEY = "security.property.file";
    private static final String ADDITIONAL_FINANCIALS_CONFIG_LOCATIONS_PARAM = "additional.kfs.config.locations";
    private static final String INSTITUTIONAL_CONFIGURATION_FILE_NAME = "institutional-config";
    private Properties props = new Properties();
    private static final Logger LOG = LogManager.getLogger(PropertyLoadingFactoryBean.class);

    public Properties getObject() {
        PropertyLoadingFactoryBean.loadBaseProperties();
        this.props.putAll((Map<?, ?>)BASE_PROPERTIES);
        PropertyLoadingFactoryBean.loadPropertyList(this.props, SECURITY_PROPERTY_FILE_NAME_KEY);
        if (LOG.isDebugEnabled()) {
            for (Object key : this.props.keySet()) {
                String value = (String)this.props.get(key);
                LOG.debug(key + ": " + value);
            }
        }
        return this.props;
    }

    public Class<Properties> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static void loadPropertyList(Properties props, String listPropertyName) {
        for (String propertyFileName : PropertyLoadingFactoryBean.getBaseListProperty(listPropertyName)) {
            PropertyLoadingFactoryBean.loadProperties(props, propertyFileName);
        }
    }

    private static void loadProperties(Properties props, String propertyFileName) {
        InputStream propertyFileInputStream = null;
        try {
            try {
                propertyFileInputStream = new DefaultResourceLoader(PropertyLoadingFactoryBean.getDefaultClassLoader()).getResource(propertyFileName).getInputStream();
                props.load(propertyFileInputStream);
            }
            finally {
                if (propertyFileInputStream != null) {
                    propertyFileInputStream.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    public static String getBaseProperty(String propertyName) {
        PropertyLoadingFactoryBean.loadBaseProperties();
        return BASE_PROPERTIES.getProperty(propertyName);
    }

    public static List<String> getBaseListProperty(String propertyName) {
        PropertyLoadingFactoryBean.loadBaseProperties();
        if (BASE_PROPERTIES.containsKey(propertyName)) {
            return Arrays.asList(BASE_PROPERTIES.getProperty(propertyName).split(","));
        }
        return Collections.emptyList();
    }

    protected static void loadBaseProperties() {
        if (BASE_PROPERTIES.isEmpty()) {
            PropertyLoadingFactoryBean.loadProperties(BASE_PROPERTIES, "classpath:/org/kuali/kfs/sys/datatools/financials-default-config.properties");
            PropertyLoadingFactoryBean.loadProperties(BASE_PROPERTIES, "classpath:/org/kuali/kfs/sys/datatools/financials-security-default-config.properties");
            PropertyLoadingFactoryBean.loadProperties(BASE_PROPERTIES, "classpath:institutional-config.properties");
            PropertyLoadingFactoryBean.loadExternalProperties(BASE_PROPERTIES, ADDITIONAL_FINANCIALS_CONFIG_LOCATIONS_PARAM);
        }
    }

    private static void loadExternalProperties(Properties props, String location) {
        String externalConfigLocationPaths = System.getProperty(location);
        if (StringUtils.isNotEmpty((CharSequence)externalConfigLocationPaths)) {
            String[] files;
            for (String f : files = externalConfigLocationPaths.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)f)) continue;
                LOG.info("Loading properties from " + f);
                PropertyLoadingFactoryBean.loadProperties(props, new StringBuffer("file:").append(f).toString());
            }
        }
        props.putAll((Map<?, ?>)System.getProperties());
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = PropertyLoadingFactoryBean.class.getClassLoader();
        }
        return classLoader;
    }
}

