/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquirelational;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.PropertySource;

public class LiquiRelational {
    private static final Logger LOG = LogManager.getLogger();
    private static final Map<Integer, String> LIQUIBASE_MASTER_FILES = Map.ofEntries(Map.entry(1, "org/kuali/kfs/db/liquibase-phase1-master.xml"), Map.entry(2, "org/kuali/kfs/db/liquibase-phase2-master.xml"), Map.entry(3, "org/kuali/kfs/db/liquibase-phase3-master.xml"), Map.entry(4, "org/kuali/kfs/db/liquibase-phase4-master.xml"), Map.entry(5, "org/kuali/kfs/db/liquibase-phase5-master.xml"));
    private static final String ADDITIONAL_PHASE5_LIQUIBASE_MASTER_FILE = "additional.phase5.liquibase.master.file";
    private static final String UPDATE_DATABASE_CONTEXT = "updateDatabaseContext";
    private static final String UPDATE_DATABASE_FULL_REBUILD = "updateDatabaseFullRebuild";
    private ClassPathXmlApplicationContext applicationContext;
    protected Properties properties = null;

    private LiquiRelational() {
    }

    public LiquiRelational(Properties properties) {
        this.properties = properties;
    }

    public static void main(String[] args) {
        Configurator.initialize((Configuration)new DefaultConfiguration());
        LiquiRelational liquiRelational = new LiquiRelational();
        liquiRelational.updateDatabase();
        System.exit(0);
    }

    public void updateDatabase() {
        this.initializeContext();
        this.applyUpdates();
        this.applicationContext.close();
    }

    private void initializeContext() {
        long startInit = System.currentTimeMillis();
        LOG.info("Initializing LiquiRelational Context...");
        this.applicationContext = new ClassPathXmlApplicationContext("org/kuali/kfs/sys/datatools/liquirelational/kfs-liqui-relational-bootstrap.xml");
        if (this.properties != null) {
            this.applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesSource("properties", this.properties));
        } else {
            this.properties = (Properties)this.applicationContext.getBean("properties", Properties.class);
        }
        this.applicationContext.start();
        long endInit = System.currentTimeMillis();
        LOG.info("...LiquiRelational Context successfully initialized, startup took {} ms.", (Object)(endInit - startInit));
    }

    private void applyUpdates() {
        DataSource dataSource = (DataSource)this.applicationContext.getBean("dataSource", DataSource.class);
        try (Connection connection = dataSource.getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.applicationContext.getClassLoader());
            String liquibaseContext = this.getBaseProperty(UPDATE_DATABASE_CONTEXT);
            this.runUpdatesPhase(database, (ResourceAccessor)resourceAccessor, liquibaseContext);
        }
        catch (SQLException | DatabaseException e) {
            LOG.error("Failed to get datasource.", e);
            throw new RuntimeException(e);
        }
    }

    private List<String> getPhasesToRun() {
        String updateDatabaseFullRebuild = this.getBaseProperty(UPDATE_DATABASE_FULL_REBUILD);
        ArrayList<String> phaseFilenames = new ArrayList<String>();
        if (Boolean.parseBoolean(updateDatabaseFullRebuild)) {
            LOG.info("getAutoPhasesToRun() Running all phases");
            for (int i = 1; i < 5; ++i) {
                phaseFilenames.add(LIQUIBASE_MASTER_FILES.get(i));
            }
        } else {
            LOG.info("getAutoPhasesToRun() Running phase 5 only");
        }
        String additionalPhase5LiquibaseMasterFile = this.getBaseProperty(ADDITIONAL_PHASE5_LIQUIBASE_MASTER_FILE);
        if (StringUtils.isNotBlank((CharSequence)additionalPhase5LiquibaseMasterFile)) {
            phaseFilenames.add(additionalPhase5LiquibaseMasterFile);
        }
        phaseFilenames.add(LIQUIBASE_MASTER_FILES.get(5));
        return phaseFilenames;
    }

    private void runUpdatesPhase(Database database, ResourceAccessor resourceAccessor, String liquibaseContext) {
        List<String> phaseFilenames = this.getPhasesToRun();
        for (String filename : phaseFilenames) {
            try {
                LOG.info("Processing {}", (Object)filename);
                Liquibase liquibase = new Liquibase(filename, resourceAccessor, database);
                liquibase.update(liquibaseContext);
            }
            catch (LiquibaseException e) {
                throw new RuntimeException("Failed to create Liquibase for " + filename, e);
            }
        }
    }

    private String getBaseProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public static class PropertiesSource
    extends PropertySource<String> {
        protected Properties properties;

        PropertiesSource(String name, Properties properties) {
            super(name);
            this.properties = properties;
        }

        public String getProperty(String s) {
            if (this.properties != null) {
                return String.valueOf(this.properties.get(s));
            }
            return null;
        }
    }
}

