/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;

public class TableDataLoader
implements CustomTaskChange {
    public static final String DATE_FORMAT = "yyyyMMddHHmmssSSSS";
    private String file;
    private String table;
    private ResourceAccessor resourceAccessor;
    private int count = 0;
    private SimpleDateFormat dateFormat;

    public String getConfirmationMessage() {
        return this.table + ": loaded " + this.count + " rows";
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public void setUp() {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void execute(Database database) throws CustomChangeException {
        if (this.table == null || this.table.length() == 0) {
            throw new CustomChangeException("Invalid table name " + this.table);
        }
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        String relativeTo = null;
        try (InputStream in = this.resourceAccessor.openStream(relativeTo, this.file);){
            if (in == null) {
                throw new CustomChangeException("Cannot find input file " + this.file);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                List<Column> columns = this.readColumns(br);
                String sql = this.insertStatement(this.table, columns);
                try (PreparedStatement ps = connection.prepareStatement(sql);){
                    List<String> fields;
                    while ((fields = this.readFields(br)) != null) {
                        if (fields.size() != columns.size()) {
                            throw new RuntimeException("Record has incorrect number of fields.");
                        }
                        ps.clearParameters();
                        for (int i = 0; i < columns.size(); ++i) {
                            this.setParameter(ps, fields.get(i), columns.get((int)i).type, i + 1);
                        }
                        ps.addBatch();
                        if (++this.count % 1000 != 0) continue;
                        ps.executeBatch();
                    }
                    ps.executeBatch();
                    connection.commit();
                }
            }
        }
        catch (Exception e) {
            throw new CustomChangeException((Throwable)e);
        }
    }

    private String insertStatement(String table, List<Column> columns) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        sql.append(table);
        sql.append(" (");
        List columnNames = columns.stream().map(c -> c.name).collect(Collectors.toList());
        sql.append(StringUtils.join(columnNames, (String)","));
        sql.append(") values (");
        Object[] placeholders = new String[columns.size()];
        Arrays.fill(placeholders, "?");
        sql.append(StringUtils.join((Object[])placeholders, (String)","));
        sql.append(")");
        return sql.toString();
    }

    private void setParameter(PreparedStatement ps, String value, int type, int pos) throws SQLException {
        if ("NULL".equals(value)) {
            ps.setString(pos, null);
            return;
        }
        if (!value.startsWith("'") || !value.endsWith("'")) {
            throw new RuntimeException("Value is not quoted");
        }
        String unquoted = value.substring("'".length(), value.length() - "'".length());
        switch (type) {
            case 91: {
                try {
                    java.util.Date d = this.dateFormat.parse(unquoted);
                    ps.setDate(pos, new Date(d.getTime()));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to convert data to date: " + unquoted, e);
                }
                return;
            }
            case 93: {
                try {
                    java.util.Date d = this.dateFormat.parse(unquoted);
                    ps.setTimestamp(pos, new Timestamp(d.getTime()));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to convert data to date: " + unquoted, e);
                }
                return;
            }
            case 2004: {
                byte[] bytes = Base64.getDecoder().decode(unquoted);
                Blob blob = ps.getConnection().createBlob();
                blob.setBytes(0L, bytes);
                ps.setBlob(pos, blob);
                return;
            }
        }
        ps.setString(pos, unquoted);
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setFile(String file) {
        this.file = file;
    }

    private List<Column> readColumns(BufferedReader br) throws Exception {
        ArrayList<Column> result = new ArrayList<Column>();
        List<String> headerfields = this.readRecord(br, "HEADER[", "]HEADER");
        if (headerfields == null) {
            throw new RuntimeException("Error: Cannot read header");
        }
        for (String headerfield : headerfields) {
            result.add(new Column(headerfield));
        }
        return result;
    }

    List<String> readFields(BufferedReader br) throws IOException {
        return this.readRecord(br, "RECORD[", "]RECORD");
    }

    private List<String> readRecord(BufferedReader br, String start, String end) throws IOException {
        String line;
        StringBuilder record = new StringBuilder();
        while ((line = br.readLine()) != null) {
            record.append(line);
            if (line.endsWith("~&~\t~&~" + end)) break;
            record.append("\n");
        }
        if (record.length() == 0) {
            return null;
        }
        List<String> result = Arrays.asList(record.toString().split("~&~\t~&~"));
        if (!start.equals(result.get(0))) {
            throw new RuntimeException("Error: missing starting record marker");
        }
        if (!end.equals(result.get(result.size() - 1))) {
            throw new RuntimeException("Error reading ending record marker");
        }
        return result.subList(1, result.size() - 1);
    }

    private class Column {
        String name;
        int type;

        Column(String columntext) throws Exception {
            this.name = StringUtils.substringBefore((String)columntext, (String)"::");
            String typename = StringUtils.substringAfter((String)columntext, (String)"::");
            this.type = Types.class.getField(typename).getInt(null);
        }
    }
}

