/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.rice.kim.api.identity.Person;

public class LedgerBalanceWithMessage {
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String positionNumber;
    private String employeeName;
    private String emplid;
    private String message;

    public LedgerBalanceWithMessage() {
        this("", "", "");
    }

    public LedgerBalanceWithMessage(String emplid, String employeeName, String message) {
        this.chartOfAccountsCode = "";
        this.accountNumber = "";
        this.subAccountNumber = "";
        this.financialObjectCode = "";
        this.positionNumber = "";
        this.emplid = emplid;
        this.employeeName = employeeName;
        this.message = message;
    }

    public LedgerBalanceWithMessage(LaborLedgerBalance ledgerBalance, String message) {
        this.chartOfAccountsCode = ledgerBalance.getChartOfAccountsCode();
        this.accountNumber = ledgerBalance.getAccountNumber();
        this.subAccountNumber = ledgerBalance.getSubAccountNumber();
        this.financialObjectCode = ledgerBalance.getFinancialObjectCode();
        this.positionNumber = ledgerBalance.getPositionNumber();
        this.emplid = ledgerBalance.getEmplid();
        this.message = message;
        Person employee = ledgerBalance.getLedgerPerson();
        this.employeeName = employee != null ? employee.getName() : "";
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public String getEmplid() {
        return this.emplid;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        StringBuilder ledgerBalanceWithMessage = new StringBuilder();
        ledgerBalanceWithMessage.append("[chartOfAccountsCode=").append(this.getChartOfAccountsCode()).append(", ");
        ledgerBalanceWithMessage.append("accountNumber=").append(this.getAccountNumber()).append(", ");
        ledgerBalanceWithMessage.append("subAccountNumber=").append(this.getSubAccountNumber()).append(", ");
        ledgerBalanceWithMessage.append("financialObjectCode=").append(this.getFinancialObjectCode()).append(", ");
        ledgerBalanceWithMessage.append("positionNumber=").append(this.getPositionNumber()).append(", ");
        ledgerBalanceWithMessage.append("emplid=").append(this.getEmplid()).append(", ");
        ledgerBalanceWithMessage.append("employeeName=").append(this.getEmployeeName()).append(", ");
        ledgerBalanceWithMessage.append("message=").append(this.getMessage()).append("]");
        return ledgerBalanceWithMessage.toString();
    }
}

