/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum AccountingPeriodMonth {
    MONTH1("01"),
    MONTH2("02"),
    MONTH3("03"),
    MONTH4("04"),
    MONTH5("05"),
    MONTH6("06"),
    MONTH7("07"),
    MONTH8("08"),
    MONTH9("09"),
    MONTH10("10"),
    MONTH11("11"),
    MONTH12("12");

    public final String periodCode;

    private AccountingPeriodMonth(String periodCode) {
        this.periodCode = periodCode;
    }

    public static AccountingPeriodMonth findAccountingPeriod(String periodCode) {
        for (AccountingPeriodMonth accountingPeriod : AccountingPeriodMonth.values()) {
            if (!accountingPeriod.periodCode.equals(periodCode)) continue;
            return accountingPeriod;
        }
        return null;
    }

    public static Map<Integer, Set<String>> findAccountingPeriodsBetween(Integer beginYear, String beginPeriodCode, Integer endYear, String endPeriodCode) {
        HashMap<Integer, Set<String>> accountingPeriods = new HashMap<Integer, Set<String>>();
        AccountingPeriodMonth beginPeriod = AccountingPeriodMonth.findAccountingPeriod(beginPeriodCode);
        AccountingPeriodMonth endPeriod = AccountingPeriodMonth.findAccountingPeriod(endPeriodCode);
        int difference = endYear - beginYear;
        if (difference > 0) {
            accountingPeriods.put(beginYear, AccountingPeriodMonth.buildPeriodCodeSetWithinRange(beginPeriod, MONTH12));
            for (int middleYear = beginYear + 1; middleYear < endYear; ++middleYear) {
                accountingPeriods.put(middleYear, AccountingPeriodMonth.buildPeriodCodeSetWithinRange(MONTH1, MONTH12));
            }
            accountingPeriods.put(endYear, AccountingPeriodMonth.buildPeriodCodeSetWithinRange(MONTH1, endPeriod));
        } else if (difference == 0) {
            accountingPeriods.put(beginYear, AccountingPeriodMonth.buildPeriodCodeSetWithinRange(beginPeriod, endPeriod));
        } else {
            throw new IllegalArgumentException("The begin year " + beginYear + "should be no later than the end year " + endYear);
        }
        return accountingPeriods;
    }

    public static Set<String> buildPeriodCodeSetWithinRange(AccountingPeriodMonth beginPeriod, AccountingPeriodMonth endPeriod) {
        if (beginPeriod.compareTo(endPeriod) > 0) {
            throw new IllegalArgumentException("The begin period " + (Object)((Object)beginPeriod) + "should be no later than the end period " + (Object)((Object)endPeriod));
        }
        HashSet<String> periodCodesWithinRange = new HashSet<String>();
        for (AccountingPeriodMonth period : EnumSet.range(beginPeriod, endPeriod)) {
            periodCodesWithinRange.add(period.periodCode);
        }
        return periodCodesWithinRange;
    }
}

