/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;

@ConfigureContext
public class EffortCertificationDocumentTest
extends KualiTestBase {
    private Properties properties;
    private Properties message;
    private String detailFieldNames;
    private String documentFieldNames;
    private String deliminator;

    public EffortCertificationDocumentTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationDocument.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
    }

    public void testGetEffortCertificationDetailWithMaxPayrollAmount_MultipleResults() throws Exception {
        String testTarget = "getEffortCertificationDetailWithMaxPayrollAmount.multipleResults.";
        EffortCertificationDocument document = this.buildDocument(testTarget);
        List detailLineWithMaxPayrollAmount = document.getEffortCertificationDetailWithMaxPayrollAmount();
        int numberOfExpectedDetail = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetail")));
        EffortCertificationDocumentTest.assertEquals((int)numberOfExpectedDetail, (int)detailLineWithMaxPayrollAmount.size());
    }

    public void testGetEffortCertificationDetailWithMaxPayrollAmount_SingleResult() throws Exception {
        String testTarget = "getEffortCertificationDetailWithMaxPayrollAmount.singleResult.";
        EffortCertificationDocument document = this.buildDocument(testTarget);
        List detailLineWithMaxPayrollAmount = document.getEffortCertificationDetailWithMaxPayrollAmount();
        int numberOfExpectedDetail = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetail")));
        EffortCertificationDocumentTest.assertEquals((int)numberOfExpectedDetail, (int)detailLineWithMaxPayrollAmount.size());
    }

    private EffortCertificationDocument buildDocument(String testTarget) {
        EffortCertificationDocument document = (EffortCertificationDocument)TestDataPreparator.buildTestDataObject(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "document"), (String)this.documentFieldNames, (String)this.deliminator);
        List<EffortCertificationDetail> detailLines = this.buildDetailLine(testTarget);
        document.setEffortCertificationDetailLines(detailLines);
        return document;
    }

    private List<EffortCertificationDetail> buildDetailLine(String testTarget) {
        int numberOfDetail = Integer.valueOf(this.properties.getProperty(testTarget + "numOfDetail"));
        return TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + "detail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetail);
    }
}

