/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ec.util.DetailLineGroup;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;

@ConfigureContext
public class DetailLineGroupTest
extends KualiTestBase {
    private final Properties properties;
    private final Properties message;
    private final String detailFieldNames;
    private final String consolidationFieldNames;
    private final String deliminator;

    public DetailLineGroupTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/detailLineGroup.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.consolidationFieldNames = this.properties.getProperty("consolidationFieldNames");
    }

    public void testConstructor_WithOneParameter() throws Exception {
        String testTarget = "constructor.withOneParameter.";
        EffortCertificationDetail detailLine = this.buildDetailLine(testTarget, "detail");
        DetailLineGroup detailLineGroupMap = new DetailLineGroup(detailLine);
        EffortCertificationDetail expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
        EffortCertificationDetail expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        DetailLineGroupTest.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)detailLineGroupMap.getSummaryDetailLine(), (List)keyFields));
        DetailLineGroupTest.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, (Object)detailLineGroupMap.getDelegateDetailLine(), (List)keyFields));
    }

    public void testUpdateDelegateDetailLineEffort() throws Exception {
        String testTarget = "updateDelegateDetailLineEffort.";
        EffortCertificationDetail detailLine = this.buildDetailLine(testTarget, "detail");
        DetailLineGroup detailLineGroupMap = new DetailLineGroup(detailLine);
        String newEffortAsString = StringUtils.trim((String)this.properties.getProperty(testTarget + "newEffortPercent"));
        Integer newEffort = Integer.parseInt(newEffortAsString);
        detailLineGroupMap.getSummaryDetailLine().setEffortCertificationUpdatedOverallPercent(newEffort);
        detailLineGroupMap.updateDelegateDetailLineEffort();
        EffortCertificationDetail expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
        EffortCertificationDetail expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        DetailLineGroupTest.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)detailLineGroupMap.getSummaryDetailLine(), (List)keyFields));
        DetailLineGroupTest.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, (Object)detailLineGroupMap.getDelegateDetailLine(), (List)keyFields));
    }

    public void testGroupDetailLines_SingleGroup() throws Exception {
        String testTarget = "groupDetailLines.singleGroup.";
        List consolidationKeyFields = ObjectUtil.split((String)this.consolidationFieldNames, (String)this.deliminator);
        int numberOfDetails = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetails")));
        List<EffortCertificationDetail> detailLines = this.buildDetailLines(testTarget, "detail", numberOfDetails);
        Map detailLineGroupMap = DetailLineGroup.groupDetailLines(detailLines);
        int numOfExpectedGroups = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedGroups")));
        DetailLineGroupTest.assertTrue((numOfExpectedGroups == detailLineGroupMap.size() ? 1 : 0) != 0);
        EffortCertificationDetail expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
        EffortCertificationDetail expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        EffortCertificationDetail summaryLine = null;
        EffortCertificationDetail delegateLine = null;
        for (String key : detailLineGroupMap.keySet()) {
            summaryLine = ((DetailLineGroup)detailLineGroupMap.get(key)).getSummaryDetailLine();
            delegateLine = ((DetailLineGroup)detailLineGroupMap.get(key)).getDelegateDetailLine();
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        DetailLineGroupTest.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)summaryLine, (List)keyFields));
        DetailLineGroupTest.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, delegateLine, (List)keyFields));
    }

    public void testGroupDetailLines_MultipleGroups() throws Exception {
        String testTarget = "groupDetailLines.multipleGroups.";
        List consolidationKeyFields = ObjectUtil.split((String)this.consolidationFieldNames, (String)this.deliminator);
        int numberOfDetails = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetails")));
        List<EffortCertificationDetail> detailLines = this.buildDetailLines(testTarget, "detail", numberOfDetails);
        Map detailLineGroupMap = DetailLineGroup.groupDetailLines(detailLines);
        int numOfExpectedGroups = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedGroups")));
        DetailLineGroupTest.assertTrue((numOfExpectedGroups == detailLineGroupMap.size() ? 1 : 0) != 0);
        List<EffortCertificationDetail> expectedSummaryLines = this.buildDetailLines(testTarget, "expectedSummaryLine", numOfExpectedGroups);
        List<EffortCertificationDetail> expectedDelegateLines = this.buildDetailLines(testTarget, "expectedDelegateLine", numOfExpectedGroups);
        ArrayList<EffortCertificationDetail> summaryLines = new ArrayList<EffortCertificationDetail>();
        ArrayList<EffortCertificationDetail> delegateLines = new ArrayList<EffortCertificationDetail>();
        for (String key : detailLineGroupMap.keySet()) {
            summaryLines.add(((DetailLineGroup)detailLineGroupMap.get(key)).getSummaryDetailLine());
            delegateLines.add(((DetailLineGroup)detailLineGroupMap.get(key)).getDelegateDetailLine());
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        DetailLineGroupTest.assertTrue((boolean)TestDataPreparator.hasSameElements(expectedSummaryLines, summaryLines, (List)keyFields));
        DetailLineGroupTest.assertTrue((boolean)TestDataPreparator.hasSameElements(expectedDelegateLines, delegateLines, (List)keyFields));
    }

    private List<EffortCertificationDetail> buildDetailLines(String testTarget, String propertyKeyPrefix, int numberOfDetails) {
        return TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + propertyKeyPrefix), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetails);
    }

    private EffortCertificationDetail buildDetailLine(String testTarget, String propertyKeyPrefix) {
        return (EffortCertificationDetail)TestDataPreparator.buildTestDataObject(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + propertyKeyPrefix), (String)this.detailFieldNames, (String)this.deliminator);
    }
}

