/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerEntry;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationCreateService;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationExtractService;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.Log4jConfigurer;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.SpringContextForBatchRunner;

public class EffortBatchRunner {
    private static Logger LOG = Logger.getLogger(EffortBatchRunner.class);
    private final Properties properties;
    private final Properties message;
    private final String balanceFieldNames;
    private final String entryFieldNames;
    private final String deliminator;
    private BusinessObjectService businessObjectService;
    private LaborModuleService laborModuleService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;
    private Class<? extends LaborLedgerEntry> ledgerEntryClass;

    public EffortBatchRunner() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationExtractServiceProformance.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
        this.entryFieldNames = this.properties.getProperty("entryFieldNames");
        Log4jConfigurer.configureLogging((boolean)false);
        SpringContextForBatchRunner.initializeKfs();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.laborModuleService = (LaborModuleService)SpringContext.getBean(LaborModuleService.class);
        KualiModuleService kualiModuleService = (KualiModuleService)SpringContext.getBean(KualiModuleService.class);
        this.ledgerBalanceClass = LedgerBalance.class;
        this.ledgerEntryClass = ((LaborLedgerEntry)kualiModuleService.getResponsibleModuleService(LaborLedgerEntry.class).createNewObjectFromExternalizableClass(LaborLedgerEntry.class)).getClass();
    }

    public void loadData() {
        this.doCleanup();
        int numberOfEmplid = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty("emplid.numOfEmplid")));
        for (int i = 1; i <= numberOfEmplid; ++i) {
            String emplid = StringUtils.trim((String)this.properties.getProperty("emplid" + i));
            this.loadDataForEmployee(emplid, i);
        }
    }

    private void doCleanup() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("universityFiscalYear", "2007");
        this.businessObjectService.deleteMatching(this.ledgerBalanceClass, fieldValues);
        this.businessObjectService.deleteMatching(this.ledgerEntryClass, fieldValues);
    }

    private void loadDataForEmployee(String emplid, Integer sequenceNumber) {
        int numberOfEntries = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty("ledgerEntry.numOfEntries")));
        List ledgerEntries = TestDataPreparator.buildTestDataList(this.ledgerEntryClass, (Properties)this.properties, (String)"ledgerEntry.seed", (String)this.entryFieldNames, (String)this.deliminator, (int)numberOfEntries);
        for (LaborLedgerEntry entry : ledgerEntries) {
            entry.setEmplid(emplid);
            entry.setTransactionLedgerEntrySequenceNumber(sequenceNumber);
        }
        this.businessObjectService.save(ledgerEntries);
        int numberOfBalances = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty("ledgerBalance.numOfBalances")));
        List ledgerBalances = TestDataPreparator.buildTestDataList(this.ledgerBalanceClass, (Properties)this.properties, (String)"ledgerBalance.seed", (String)this.balanceFieldNames, (String)this.deliminator, (int)numberOfBalances);
        for (LaborLedgerBalance balance : ledgerBalances) {
            balance.setEmplid(emplid);
        }
        this.businessObjectService.save(ledgerBalances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        EffortBatchRunner batchRunner = new EffortBatchRunner();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
        Integer fiscalYear = 2007;
        String reportPeriod = "A01";
        if (args.length < 1) {
            throw new IllegalArgumentException("Wrong argument -- The argument only can be -load, -extract or -create");
        }
        if (args.length >= 3) {
            fiscalYear = StringUtils.isNumeric((String)args[1]) ? Integer.parseInt(args[1]) : fiscalYear;
            reportPeriod = StringUtils.isNotBlank((String)args[2]) ? StringUtils.trim((String)args[2]).toUpperCase() : reportPeriod;
        }
        try {
            if (StringUtils.equalsIgnoreCase((String)"-load", (String)args[0])) {
                System.out.println("Loading data into labor Entry and balance tables ...");
                batchRunner.loadData();
            } else if (StringUtils.equalsIgnoreCase((String)"-extract", (String)args[0])) {
                System.out.println("Extracting Effort Certifications ...");
                EffortCertificationExtractService effortCertificationExtractService = (EffortCertificationExtractService)SpringContext.getBean(EffortCertificationExtractService.class);
                effortCertificationExtractService.extract(fiscalYear, reportPeriod);
            } else if (StringUtils.equalsIgnoreCase((String)"-create", (String)args[0])) {
                System.out.println("Creating Effort Certifications ...");
                EffortCertificationCreateService effortCertificationCreateService = (EffortCertificationCreateService)SpringContext.getBean(EffortCertificationCreateService.class);
                effortCertificationCreateService.create(fiscalYear, reportPeriod);
            } else {
                EffortCertificationExtractService effortCertificationExtractService = (EffortCertificationExtractService)SpringContext.getBean(EffortCertificationExtractService.class);
                effortCertificationExtractService.extract(fiscalYear, reportPeriod);
                EffortCertificationCreateService effortCertificationCreateService = (EffortCertificationCreateService)SpringContext.getBean(EffortCertificationCreateService.class);
                effortCertificationCreateService.create(fiscalYear, reportPeriod);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }
}

